/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.init;

import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.l2backpack.compat.GolemCompat;
import dev.xkmc.l2backpack.compat.LCCompat;
import dev.xkmc.l2backpack.compat.PatchouliClickListener;
import dev.xkmc.l2backpack.compat.PatchouliCompat;
import dev.xkmc.l2backpack.compat.SophisticatedClickListener;
import dev.xkmc.l2backpack.compat.SophisticatedCompat;
import dev.xkmc.l2backpack.content.bag.BagCaps;
import dev.xkmc.l2backpack.content.bag.BagItemHandler;
import dev.xkmc.l2backpack.content.capability.PickupModeCap;
import dev.xkmc.l2backpack.content.common.BaseBagInvWrapper;
import dev.xkmc.l2backpack.content.common.BaseBagItemHandler;
import dev.xkmc.l2backpack.content.drawer.DrawerItem;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalCaps;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerItem;
import dev.xkmc.l2backpack.content.remote.player.EnderBackpackCaps;
import dev.xkmc.l2backpack.content.remote.player.EnderSyncCap;
import dev.xkmc.l2backpack.content.remote.player.EnderSyncPacket;
import dev.xkmc.l2backpack.events.BackpackSel;
import dev.xkmc.l2backpack.events.BackpackSlotClickListener;
import dev.xkmc.l2backpack.init.data.LBAdvGen;
import dev.xkmc.l2backpack.init.data.LBConfig;
import dev.xkmc.l2backpack.init.data.LBLang;
import dev.xkmc.l2backpack.init.data.LBRecipeGen;
import dev.xkmc.l2backpack.init.data.LBTagGen;
import dev.xkmc.l2backpack.init.data.SlotGen;
import dev.xkmc.l2backpack.init.loot.LootGen;
import dev.xkmc.l2backpack.init.registrate.LBBlocks;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2backpack.init.registrate.LBMenu;
import dev.xkmc.l2backpack.init.registrate.LBMisc;
import dev.xkmc.l2backpack.init.registrate.LBTriggers;
import dev.xkmc.l2backpack.network.ClickInteractToServer;
import dev.xkmc.l2backpack.network.CreativeSetCarryToClient;
import dev.xkmc.l2backpack.network.CreativeSetCarryToServer;
import dev.xkmc.l2backpack.network.RequestTooltipUpdateEvent;
import dev.xkmc.l2backpack.network.RespondTooltipUpdateEvent;
import dev.xkmc.l2core.compat.patchouli.PatchouliHelper;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2core.util.MathHelper;
import dev.xkmc.l2itemselector.select.ISelectionListener;
import dev.xkmc.l2itemselector.select.SelectionRegistry;
import dev.xkmc.l2serial.network.PacketHandler;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="l2backpack")
@EventBusSubscriber(modid="l2backpack", bus=EventBusSubscriber.Bus.MOD)
public class L2Backpack {
    public static final String MODID = "l2backpack";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Reg REG = new Reg("l2backpack");
    public static final L2Registrate REGISTRATE = new L2Registrate("l2backpack");
    public static final BackpackSlotClickListener SLOT_CLICK = new BackpackSlotClickListener();
    public static final PacketHandler HANDLER = new PacketHandler("l2backpack", 3, new Function[]{e -> e.create(ClickInteractToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(CreativeSetCarryToClient.class, PacketHandler.NetDir.PLAY_TO_CLIENT), e -> e.create(CreativeSetCarryToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(RequestTooltipUpdateEvent.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(RespondTooltipUpdateEvent.class, PacketHandler.NetDir.PLAY_TO_CLIENT), e -> e.create(EnderSyncPacket.class, PacketHandler.NetDir.PLAY_TO_CLIENT)});
    public static final PatchouliHelper PATCHOULI = new PatchouliHelper(REGISTRATE, "backpack_guide");

    public L2Backpack() {
        LBBlocks.register();
        LBItems.register();
        LBMenu.register();
        LBMisc.register();
        LBTriggers.register();
        LBConfig.init();
        PickupModeCap.register();
        EnderSyncCap.register();
        if (ModList.get().isLoaded("modulargolems")) {
            GolemCompat.register();
        }
        if (ModList.get().isLoaded("l2complements")) {
            NeoForge.EVENT_BUS.register(LCCompat.class);
        }
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, LBRecipeGen::genRecipe);
        REGISTRATE.addDataGenerator(ProviderType.ADVANCEMENT, LBAdvGen::genAdvancements);
        REGISTRATE.addDataGenerator(ProviderType.LOOT, LootGen::genLoot);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, LBTagGen::onBlockTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, LBTagGen::onItemTagGen);
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.gen();
            new PatchouliClickListener();
            NeoForge.EVENT_BUS.register(PatchouliClickListener.class);
        }
        if (ModList.get().isLoaded("sophisticatedbackpacks")) {
            SophisticatedCompat.init();
            new SophisticatedClickListener();
            NeoForge.EVENT_BUS.register(SophisticatedCompat.class);
        }
        SelectionRegistry.register((int)1000, (ISelectionListener)BackpackSel.INSTANCE);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        ItemEntry[] backpacks = (ItemEntry[])MathHelper.merge((Object[])LBItems.BACKPACKS, (Object[])new ItemEntry[]{LBItems.QUIVER, LBItems.SCABBARD, LBItems.ARMOR_SWAP, LBItems.SUIT_SWAP, LBItems.HANDSWAP});
        event.registerItem(LBMisc.PICKUP, (stack, c) -> new BaseBagInvWrapper((ItemStack)stack), (ItemLike[])backpacks);
        event.registerItem(LBMisc.PICKUP, (stack, c) -> new EnderBackpackCaps((ItemStack)stack), new ItemLike[]{LBItems.ENDER_BACKPACK});
        event.registerItem(LBMisc.PICKUP, (stack, c) -> new DimensionalCaps((ItemStack)stack), LBItems.DIMENSIONAL_STORAGE);
        event.registerItem(LBMisc.PICKUP, ((DrawerItem)LBItems.DRAWER.get())::getCaps, new ItemLike[]{LBItems.DRAWER});
        event.registerItem(LBMisc.PICKUP, ((EnderDrawerItem)LBItems.ENDER_DRAWER.get())::getCaps, new ItemLike[]{LBItems.ENDER_DRAWER});
        event.registerItem(LBMisc.PICKUP, (stack, c) -> new BagCaps((ItemStack)stack), new ItemLike[]{LBItems.ARMOR_BAG, LBItems.BOOK_BAG});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, c) -> new BaseBagItemHandler((ItemStack)stack), (ItemLike[])backpacks);
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, c) -> new BagItemHandler((ItemStack)stack), new ItemLike[]{LBItems.ARMOR_BAG, LBItems.BOOK_BAG});
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)LBBlocks.TE_DRAWER.get(), (be, dir) -> be.handler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)LBBlocks.TE_ENDER_DRAWER.get(), (be, dir) -> be.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)LBBlocks.TE_DIMENSIONAL.get(), (be, dir) -> be.getItemHandler());
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(LBMisc::commonSetup);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        LBLang.addTranslations((arg_0, arg_1) -> ((L2Registrate)REGISTRATE).addRawLang(arg_0, arg_1));
        DataGenerator gen = event.getGenerator();
        boolean server = event.includeServer();
        gen.addProvider(server, (DataProvider)new SlotGen(gen.getPackOutput(), event.getExistingFileHelper(), event.getLookupProvider()));
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }
}

