/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.events;

import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.LBConfig;
import dev.xkmc.l2backpack.init.data.LBTagGen;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import java.util.List;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="l2backpack", bus=EventBusSubscriber.Bus.GAME)
public class StartUpGiveItemEvents {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        ItemStack stack2;
        if (event.getEntity().tickCount != 10) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        int time = sp.getStats().getValue(Stats.CUSTOM.get((Object)Stats.PLAY_TIME));
        if (time > 100) {
            return;
        }
        AdvancementHolder adv = sp.server.getAdvancements().get(L2Backpack.loc("detection"));
        if (adv == null) {
            return;
        }
        AdvancementProgress prog = sp.getAdvancements().getOrStartProgress(adv);
        if (prog.isDone()) {
            return;
        }
        int target = (Integer)LBConfig.SERVER.startupBackpackCondition.get();
        NonNullList list = sp.getInventory().items;
        int count = 0;
        for (ItemStack stack2 : list) {
            if (stack2.isEmpty()) continue;
            ++count;
        }
        if (count < target) {
            return;
        }
        int initialRow = Math.max((Integer)LBConfig.SERVER.initialRows.get(), (count - 1) / 9 + 1);
        stack2 = LBItems.DC_ROW.set(LBItems.BACKPACKS[DyeColor.WHITE.ordinal()].asStack(), (Object)initialRow);
        NonNullList ans = NonNullList.withSize((int)(initialRow * 9), (Object)ItemStack.EMPTY);
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = (ItemStack)list.get(i);
            if (item.isEmpty() || !item.getItem().canFitInsideContainerItems() || item.is(LBTagGen.BACKPACK_BLACKLIST)) continue;
            ans.set(index++, (Object)item.copy());
            list.set(i, (Object)ItemStack.EMPTY);
        }
        BaseBagItem.setItems(stack2, (List<ItemStack>)ans);
        sp.getInventory().placeItemBackInInventory(stack2);
    }
}

