/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.events;

import com.mojang.blaze3d.platform.InputConstants;
import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.capability.PickupBagItem;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.drawer.DrawerItem;
import dev.xkmc.l2backpack.content.insert.OverlayInsertItem;
import dev.xkmc.l2backpack.content.tool.IBagTool;
import dev.xkmc.l2backpack.events.BackpackSlotClickListener;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.LBKeys;
import dev.xkmc.l2backpack.network.ClickInteractToServer;
import dev.xkmc.l2backpack.network.CreativeSetCarryToServer;
import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.l2itemselector.events.GenericKeyEvent;
import dev.xkmc.l2serial.network.SimplePacketBase;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="l2backpack", bus=EventBusSubscriber.Bus.GAME)
public class ClientEventHandler {
    @SubscribeEvent
    public static void keyEvent(GenericKeyEvent event) {
        if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)292)) {
            return;
        }
        if (Minecraft.getInstance().screen == null && Proxy.getClientPlayer() != null && event.test(LBKeys.OPEN.map.getKey()) && event.getAction() == 1 && (BackpackSlotClickListener.canOpen(Proxy.getClientPlayer().getItemBySlot(EquipmentSlot.CHEST)) || BackpackSlotClickListener.canOpen(Proxy.getClientPlayer().getItemBySlot(EquipmentSlot.LEGS)) || CuriosCompat.getSlot((LivingEntity)Proxy.getClientPlayer(), BackpackSlotClickListener::canOpen).isPresent())) {
            L2Backpack.SLOT_CLICK.keyBind();
        }
    }

    @SubscribeEvent
    public static void onScreenLeftClick(ScreenEvent.MouseButtonReleased.Pre event) {
        AbstractContainerScreen scr;
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen && (scr = (AbstractContainerScreen)screen).getMenu().getCarried().getItem() instanceof IBagTool) {
            Slot slot = scr.getSlotUnderMouse();
            if (slot != null && slot.getItem().getItem() instanceof PickupBagItem) {
                if (scr instanceof CreativeModeInventoryScreen) {
                    L2Backpack.HANDLER.toServer((SimplePacketBase)new CreativeSetCarryToServer(ItemStack.EMPTY));
                }
                event.setCanceled(true);
            }
            return;
        }
        if (ClientEventHandler.onRelease(event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onScreenRightClick(ScreenEvent.MouseButtonPressed.Pre event) {
        AbstractContainerScreen scr;
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen && (scr = (AbstractContainerScreen)screen).getMenu().getCarried().getItem() instanceof IBagTool) {
            Slot slot = scr.getSlotUnderMouse();
            if (slot != null && slot.getItem().getItem() instanceof PickupBagItem && scr instanceof CreativeModeInventoryScreen) {
                L2Backpack.HANDLER.toServer((SimplePacketBase)new CreativeSetCarryToServer(scr.getMenu().getCarried()));
            }
            return;
        }
        if (ClientEventHandler.onPress(event)) {
            event.setCanceled(true);
        }
    }

    private static boolean onRelease(ScreenEvent.MouseButtonReleased.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            OverlayInsertItem item;
            Item item2;
            boolean bypass;
            AbstractContainerScreen cont = (AbstractContainerScreen)screen;
            Slot slot = cont.getSlotUnderMouse();
            ItemStack carried = cont.getMenu().getCarried();
            boolean bl = bypass = !carried.isEmpty() && slot != null && (item2 = slot.getItem().getItem()) instanceof OverlayInsertItem && !(item = (OverlayInsertItem)item2).mayClientTake();
            if (bypass || event.getButton() == 0) {
                return ClientEventHandler.insertItem((ScreenEvent)event, cont, slot, true, event.getButton());
            }
            if (event.getButton() == 1 && slot != null) {
                item2 = slot.getItem().getItem();
                return item2 instanceof OverlayInsertItem && (item = (OverlayInsertItem)item2).mayClientTake() && !cont.getMenu().getCarried().isEmpty();
            }
        }
        return false;
    }

    private static boolean onPress(ScreenEvent.MouseButtonPressed.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            OverlayInsertItem item;
            Item item2;
            boolean bypass;
            AbstractContainerScreen cont = (AbstractContainerScreen)screen;
            Slot slot = cont.getSlotUnderMouse();
            ItemStack carried = cont.getMenu().getCarried();
            boolean bl = bypass = !carried.isEmpty() && slot != null && (item2 = slot.getItem().getItem()) instanceof OverlayInsertItem && !(item = (OverlayInsertItem)item2).mayClientTake();
            if (bypass || event.getButton() == 0) {
                return ClientEventHandler.insertItem((ScreenEvent)event, cont, slot, false, event.getButton());
            }
            if (event.getButton() == 1) {
                if (ClientEventHandler.extractItem(event, cont, slot)) {
                    return true;
                }
                if (slot != null) {
                    return slot.getItem().getItem() instanceof BaseDrawerItem && !cont.getMenu().getCarried().isEmpty();
                }
            }
        }
        return false;
    }

    private static boolean insertItem(ScreenEvent event, AbstractContainerScreen<?> cont, @Nullable Slot slot, boolean perform, int button) {
        if (slot == null) {
            return false;
        }
        ItemStack storage = slot.getItem();
        ItemStack carried = cont.getMenu().getCarried();
        Item item = storage.getItem();
        if (!(item instanceof OverlayInsertItem)) {
            return false;
        }
        OverlayInsertItem drawer = (OverlayInsertItem)item;
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null || !slot.allowModification((Player)player)) {
            return false;
        }
        return drawer.clientInsert(storage, carried, cont.getMenu().containerId, slot, perform, button, ClickInteractToServer.Callback.REGULAR, 0);
    }

    private static boolean extractItem(ScreenEvent.MouseButtonPressed.Pre event, AbstractContainerScreen<?> cont, @Nullable Slot slot) {
        if (slot == null) {
            return false;
        }
        ItemStack stack = cont.getMenu().getCarried();
        ItemStack drawerStack = slot.getItem();
        Item item = drawerStack.getItem();
        if (!(item instanceof OverlayInsertItem)) {
            return false;
        }
        OverlayInsertItem drawer = (OverlayInsertItem)item;
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null || !slot.allowModification((Player)player)) {
            return false;
        }
        if (drawer.mayClientTake() && stack.isEmpty()) {
            if (Screen.hasShiftDown()) {
                ClientEventHandler.sendDrawerPacket(ClickInteractToServer.Type.QUICK_MOVE, cont, slot);
            } else {
                ClientEventHandler.sendDrawerPacket(ClickInteractToServer.Type.TAKE, cont, slot);
            }
            return true;
        }
        return false;
    }

    private static void sendDrawerPacket(ClickInteractToServer.Type type, AbstractContainerScreen<?> cont, Slot slot) {
        ClientEventHandler.sendDrawerPacket(type, cont, slot, ClickInteractToServer.Callback.REGULAR, 0);
    }

    private static void sendDrawerPacket(ClickInteractToServer.Type type, AbstractContainerScreen<?> cont, Slot slot, ClickInteractToServer.Callback suppress, int limit) {
        int index = cont.getMenu().containerId == 0 ? slot.getSlotIndex() : slot.index;
        L2Backpack.HANDLER.toServer((SimplePacketBase)new ClickInteractToServer(type, cont.getMenu().containerId, index, cont.getMenu().getCarried(), suppress, limit));
    }

    public static boolean clientDrawerTake(AbstractContainerScreen<?> cont, Slot slot) {
        ItemStack stack = cont.getMenu().getCarried();
        ItemStack drawerStack = slot.getItem();
        Item item = drawerStack.getItem();
        if (!(item instanceof DrawerItem)) {
            return false;
        }
        DrawerItem drawer = (DrawerItem)item;
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null || !slot.allowModification((Player)player)) {
            return false;
        }
        if (drawer.mayClientTake() && stack.isEmpty()) {
            cont.getMenu().setCarried(drawer.takeItem(drawerStack, Integer.MAX_VALUE, (Player)Proxy.getClientPlayer(), false));
            ClientEventHandler.sendDrawerPacket(ClickInteractToServer.Type.TAKE, cont, slot, ClickInteractToServer.Callback.SUPPRESS, 0);
            return true;
        }
        return false;
    }

    public static boolean clientDrawerInsert(AbstractContainerScreen<?> cont, Slot slot, int limit) {
        ItemStack storage = slot.getItem();
        ItemStack carried = cont.getMenu().getCarried();
        Item item = storage.getItem();
        if (!(item instanceof OverlayInsertItem)) {
            return false;
        }
        OverlayInsertItem drawer = (OverlayInsertItem)item;
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null || !slot.allowModification((Player)player)) {
            return false;
        }
        boolean ans = drawer.clientInsert(storage, carried, cont.getMenu().containerId, slot, true, 0, limit == 0 ? ClickInteractToServer.Callback.SCRAMBLE : ClickInteractToServer.Callback.SUPPRESS, limit);
        if (ans) {
            if (limit == 0) {
                cont.getMenu().setCarried(ItemStack.EMPTY);
            } else {
                cont.getMenu().getCarried().shrink(limit);
            }
        }
        return ans;
    }
}

