/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.events;

import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.capability.PickupModeCap;
import dev.xkmc.l2backpack.content.capability.PickupTrace;
import dev.xkmc.l2backpack.init.registrate.LBMisc;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;

@EventBusSubscriber(modid="l2backpack", bus=EventBusSubscriber.Bus.GAME)
public class CapabilityEvents {
    @SubscribeEvent
    public static void onItemPickup(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemEntity e = event.getItemEntity();
        UUID uuid = e.getTarget();
        if (e.hasPickUpDelay() || uuid != null && !uuid.equals(player2.getUUID())) {
            return;
        }
        ItemStack stack = event.getItemEntity().getItem();
        ItemStack copy = stack.copy();
        int count = stack.getCount();
        CapabilityEvents.tryInsertItem(player2, stack);
        if (count != stack.getCount()) {
            copy.shrink(stack.getCount());
            player2.take((Entity)event.getItemEntity(), copy.getCount());
            CriteriaTriggers.INVENTORY_CHANGED.trigger(player2, player2.getInventory(), copy);
        }
    }

    public static void tryInsertItem(ServerPlayer player, ItemStack stack) {
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        PickupModeCap cap = (PickupModeCap)chest.getCapability(LBMisc.PICKUP);
        if (cap != null) {
            cap.doPickup(stack, new PickupTrace(false, player));
        }
        if (stack.isEmpty()) {
            return;
        }
        CuriosCompat.getSlot((LivingEntity)player, e -> {
            if (stack.isEmpty()) {
                return false;
            }
            PickupModeCap ecap = (PickupModeCap)e.getCapability(LBMisc.PICKUP);
            if (ecap != null) {
                ecap.doPickup(stack, new PickupTrace(false, player));
            }
            return false;
        });
    }
}

