/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.events;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.bag.AbstractBag;
import dev.xkmc.l2backpack.content.capability.PickupBagItem;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalItem;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalMenuPvd;
import dev.xkmc.l2backpack.content.remote.player.EnderBackpackItem;
import dev.xkmc.l2backpack.content.tool.IBagTool;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.advancement.SlotClickTrigger;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2backpack.init.registrate.LBTriggers;
import dev.xkmc.l2menustacker.click.writable.ClickedPlayerSlotResult;
import dev.xkmc.l2menustacker.click.writable.ContainerCallback;
import dev.xkmc.l2menustacker.click.writable.WritableStackClickHandler;
import dev.xkmc.l2menustacker.init.L2MenuStacker;
import dev.xkmc.l2menustacker.screen.base.ScreenTracker;
import dev.xkmc.l2menustacker.screen.packets.CacheMouseToClient;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackSlotClickListener
extends WritableStackClickHandler {
    public static boolean canOpen(ItemStack stack) {
        return stack.getItem() instanceof BaseBagItem || stack.getItem() instanceof EnderBackpackItem || stack.getItem() instanceof DimensionalItem;
    }

    public BackpackSlotClickListener() {
        super(L2Backpack.loc("backpack"));
    }

    public boolean isAllowed(ItemStack itemStack) {
        return BackpackSlotClickListener.canOpen(itemStack) || itemStack.getItem() instanceof BaseDrawerItem || itemStack.getItem() instanceof AbstractBag;
    }

    public void keyBind() {
        this.slotClickToServer(-1, -1, -1);
    }

    protected ClickedPlayerSlotResult getSlot(ServerPlayer player, int index, int slot, int wid) {
        if (wid == -1) {
            Optional<Pair<ItemStack, PlayerSlot<?>>> pairOpt;
            if (player.containerMenu != player.inventoryMenu) {
                return null;
            }
            ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
            if (BackpackSlotClickListener.canOpen(stack)) {
                return new ClickedPlayerSlotResult(stack, PlayerSlot.ofInventory((int)(36 + EquipmentSlot.CHEST.getIndex())), (ContainerCallback)new PlayerInvCallback());
            }
            stack = player.getItemBySlot(EquipmentSlot.LEGS);
            if (BackpackSlotClickListener.canOpen(stack)) {
                return new ClickedPlayerSlotResult(stack, PlayerSlot.ofInventory((int)(36 + EquipmentSlot.LEGS.getIndex())), (ContainerCallback)new PlayerInvCallback());
            }
            if (!BackpackSlotClickListener.canOpen(stack) && (pairOpt = CuriosCompat.getSlot((LivingEntity)player, BackpackSlotClickListener::canOpen)).isPresent()) {
                return new ClickedPlayerSlotResult((ItemStack)pairOpt.get().getFirst(), (PlayerSlot)pairOpt.get().getSecond(), (ContainerCallback)new PlayerInvCallback());
            }
            return null;
        }
        return super.getSlot(player, index, slot, wid);
    }

    public void handle(ServerPlayer player, int index, int slot, int wid) {
        ClickedPlayerSlotResult result = this.getSlot(player, index, slot, wid);
        if (result != null) {
            this.handle(player, result);
        } else {
            this.handleNoMenu(player, index);
        }
    }

    private void handleNoMenu(ServerPlayer player, int index) {
        if (index < 0) {
            return;
        }
        Slot slot = player.containerMenu.getSlot(index);
        ItemStack stack = slot.getItem();
        ItemStack carried = player.containerMenu.getCarried();
        Item item = carried.getItem();
        if (item instanceof IBagTool) {
            IBagTool tool = (IBagTool)item;
            if (stack.getItem() instanceof PickupBagItem) {
                tool.click(stack);
                slot.set(stack);
                return;
            }
        }
        if (!carried.isEmpty()) {
            return;
        }
        if (stack.getItem() instanceof BaseDrawerItem) {
            return;
        }
        boolean others = false;
        ScreenTracker.onServerOpen((ServerPlayer)player);
        if (stack.getItem() instanceof EnderBackpackItem) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, pl) -> ChestMenu.threeRows((int)id, (Inventory)inv, (Container)pl.getEnderChestInventory()), stack.getHoverName()));
        } else {
            Item item2 = stack.getItem();
            if (item2 instanceof DimensionalItem) {
                DimensionalItem chest = (DimensionalItem)item2;
                UUID id2 = (UUID)LBItems.DC_OWNER_ID.get(stack);
                others = id2 != null && !id2.equals(player.getUUID());
                new DimensionalMenuPvd(player, stack, chest).open();
            }
        }
        if (others) {
            ((PlayerTrigger)LBTriggers.SHARE.get()).trigger(player);
        }
    }

    protected void handle(ServerPlayer player, ClickedPlayerSlotResult result) {
        Item item;
        boolean others = false;
        boolean keybind = result.container() instanceof PlayerInvCallback;
        ItemStack carried = player.containerMenu.getCarried();
        if (!keybind && (item = carried.getItem()) instanceof IBagTool) {
            IBagTool tool = (IBagTool)item;
            if (result.stack().getItem() instanceof PickupBagItem) {
                tool.click(result.stack());
                result.container().update();
                return;
            }
        }
        if (!carried.isEmpty()) {
            return;
        }
        if (result.stack().getItem() instanceof BaseDrawerItem) {
            return;
        }
        if (!keybind) {
            ScreenTracker.onServerOpen((ServerPlayer)player);
        }
        Item item2 = result.stack().getItem();
        Objects.requireNonNull(item2);
        Item item3 = item2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BaseBagItem.class, EnderBackpackItem.class, DimensionalItem.class}, (Object)item3, n)) {
            case 0: {
                BaseBagItem bag = (BaseBagItem)item3;
                L2MenuStacker.PACKET_HANDLER.toClientPlayer((SimplePacketBase)new CacheMouseToClient(), player);
                bag.open(player, result.slot(), result.stack());
                result.container().update();
                break;
            }
            case 1: {
                EnderBackpackItem ender = (EnderBackpackItem)item3;
                L2MenuStacker.PACKET_HANDLER.toClientPlayer((SimplePacketBase)new CacheMouseToClient(), player);
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, pl) -> ChestMenu.threeRows((int)id, (Inventory)inv, (Container)pl.getEnderChestInventory()), result.stack().getHoverName()));
                break;
            }
            case 2: {
                DimensionalItem chest = (DimensionalItem)item3;
                L2MenuStacker.PACKET_HANDLER.toClientPlayer((SimplePacketBase)new CacheMouseToClient(), player);
                UUID id2 = (UUID)LBItems.DC_OWNER_ID.get(result.stack());
                others = id2 != null && !id2.equals(player.getUUID());
                new DimensionalMenuPvd(player, result.stack(), chest).open();
                result.container().update();
                break;
            }
        }
        ((SlotClickTrigger)((Object)LBTriggers.SLOT_CLICK.get())).trigger(player, result.slot().type(), keybind);
        if (others) {
            ((PlayerTrigger)LBTriggers.SHARE.get()).trigger(player);
        }
    }

    public record PlayerInvCallback() implements ContainerCallback
    {
        public void update() {
        }
    }
}

