/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.events;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.entry.ISwapEntry;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapManager;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapTypes;
import dev.xkmc.l2backpack.events.ItemStackShrinkProvider;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingGetProjectileEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="l2backpack", bus=EventBusSubscriber.Bus.GAME)
public class ArrowBagEvents {
    @SubscribeEvent
    public static void onProjectileSearch(LivingGetProjectileEvent event) {
        Item item = event.getProjectileWeaponItemStack().getItem();
        if (!(item instanceof ProjectileWeaponItem)) {
            return;
        }
        ProjectileWeaponItem weapon = (ProjectileWeaponItem)item;
        ArrowFindEvent finder = new ArrowFindEvent(event.getProjectileWeaponItemStack(), weapon, event.getEntity());
        NeoForge.EVENT_BUS.post((Event)finder);
        Pair<ItemStack, IntConsumer> arrow = finder.arrow;
        if (arrow != null) {
            ((ItemStackShrinkProvider)arrow.getFirst()).l2backpack$setShrinkListener((IntConsumer)arrow.getSecond());
            event.setProjectileItemStack((ItemStack)arrow.getFirst());
        }
    }

    @SubscribeEvent
    public static void onArrowFind(ArrowFindEvent event) {
        int selected;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        IQuickSwapToken<?> token = QuickSwapManager.getToken(event.getEntity(), event.getStack(), false);
        if (token == null) {
            return;
        }
        if (token.type() != QuickSwapTypes.ARROW) {
            return;
        }
        List<?> arrows = token.getList();
        ISwapEntry entry = (ISwapEntry)arrows.get(selected = token.getSelected());
        ItemStack stack = entry.getStack();
        if (stack.isEmpty()) {
            return;
        }
        event.setProjectile((Pair<ItemStack, IntConsumer>)Pair.of((Object)stack, token::shrink));
    }

    public static class ArrowFindEvent
    extends Event {
        private final ItemStack stack;
        private final ProjectileWeaponItem weapon;
        private final LivingEntity entity;
        private Pair<ItemStack, IntConsumer> arrow;

        public ArrowFindEvent(ItemStack stack, ProjectileWeaponItem weapon, LivingEntity entity) {
            this.stack = stack;
            this.weapon = weapon;
            this.entity = entity;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public boolean setProjectile(Pair<ItemStack, IntConsumer> arrow) {
            if (this.weapon.getAllSupportedProjectiles().test((ItemStack)arrow.getFirst())) {
                this.arrow = arrow;
                return true;
            }
            return false;
        }

        @Nullable
        public Pair<ItemStack, IntConsumer> getArrow() {
            return this.arrow;
        }
    }
}

