/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.tool;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalBlockEntity;
import dev.xkmc.l2backpack.content.tool.IBagTool;
import dev.xkmc.l2backpack.events.BackpackSlotClickListener;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class TweakerTool
extends Item
implements IBagTool {
    public TweakerTool(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Optional<Pair<ItemStack, PlayerSlot<?>>> opt;
        ItemStack stack = player.getItemInHand(hand);
        ItemStack bag = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!BackpackSlotClickListener.canOpen(bag) && (opt = CuriosCompat.getSlot((LivingEntity)player, BackpackSlotClickListener::canOpen)).isPresent()) {
            bag = (ItemStack)opt.get().getFirst();
        }
        if (BackpackSlotClickListener.canOpen(bag)) {
            if (!level.isClientSide()) {
                this.click(bag);
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    MutableComponent msg = bag.getHoverName().copy().append(": ").append(this.message(PickupConfig.get(bag)));
                    sp.sendSystemMessage((Component)msg, true);
                }
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockEntity blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (blockEntity instanceof DimensionalBlockEntity) {
            DimensionalBlockEntity be = (DimensionalBlockEntity)blockEntity;
            if (!ctx.getLevel().isClientSide()) {
                be.setPickupMode(this.click(be.config));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    public abstract PickupConfig click(PickupConfig var1);

    public abstract Component message(PickupConfig var1);
}

