/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.player;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapType;
import dev.xkmc.l2backpack.content.remote.player.EnderSyncPacket;
import dev.xkmc.l2backpack.content.remote.player.EnderTickEvent;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2core.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class EnderSyncCap
extends PlayerCapabilityTemplate<EnderSyncCap> {
    public NonNullList<ItemStack> clientEnderInv = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private Level level = null;

    public void onClone(Player player, boolean isWasDeath) {
        this.clientEnderInv.clear();
    }

    public void tick(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (this.level != player.level()) {
            this.level = player.level();
            this.clientEnderInv.clear();
        }
        ArrayList<Pair<Integer, ItemStack>> changes = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < 27; ++i) {
            ItemStack stack = player.getEnderChestInventory().getItem(i);
            if (!stack.isEmpty()) {
                NeoForge.EVENT_BUS.post((Event)new EnderTickEvent(sp, stack, i));
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)this.clientEnderInv.get(i)))) continue;
            this.clientEnderInv.set(i, (Object)stack.copy());
            changes.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)stack));
        }
        if (!changes.isEmpty()) {
            L2Backpack.HANDLER.toClientPlayer((SimplePacketBase)EnderSyncPacket.of(changes), (ServerPlayer)player);
        }
    }

    public static void register() {
    }

    public List<ItemStack> getItems(Player player) {
        if (player.level().isClientSide()) {
            return this.clientEnderInv;
        }
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
        for (int i = 0; i < 27; ++i) {
            ans.add(player.getEnderChestInventory().getItem(i));
        }
        return ans;
    }

    public void setItem(int slot, ItemStack stack) {
        this.clientEnderInv.set(slot, (Object)stack);
    }

    @Nullable
    public IQuickSwapToken<?> getToken(Player player, QuickSwapType type) {
        for (ItemStack stack : this.getItems(player)) {
            IQuickSwapToken<?> token;
            IQuickSwapItem item;
            Item item2 = stack.getItem();
            if (!(item2 instanceof IQuickSwapItem) || !((item = (IQuickSwapItem)item2) instanceof BaseBagItem) || (token = item.getTokenOfType(stack, (LivingEntity)player, type)) == null) continue;
            return token;
        }
        return null;
    }
}

