/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.player;

import dev.xkmc.l2backpack.content.capability.PickupBagItem;
import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.common.BackpackModelItem;
import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.common.InvTooltip;
import dev.xkmc.l2backpack.content.common.TooltipInvItem;
import dev.xkmc.l2backpack.content.insert.InsertOnlyItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapType;
import dev.xkmc.l2backpack.content.remote.player.EnderSyncCap;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.LBLang;
import dev.xkmc.l2backpack.init.registrate.LBMisc;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class EnderBackpackItem
extends Item
implements BackpackModelItem,
PickupBagItem,
InsertOnlyItem,
TooltipInvItem,
IQuickSwapItem {
    public EnderBackpackItem(Item.Properties props) {
        super(props.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, pl) -> ChestMenu.threeRows((int)id, (Inventory)inv, (Container)player.getEnderChestInventory()), stack.getHoverName()));
        } else {
            ContentTransfer.playSound(player);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        PickupConfig.addText(stack, list);
        LBLang.addInfo(flag, list, LBLang.Info.QUICK_ANY_ACCESS, LBLang.Info.KEYBIND, LBLang.Info.PICKUP);
        LBLang.altInsert(flag, list);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return armorType == EquipmentSlot.CHEST;
    }

    @Override
    public ResourceLocation getModelTexture(ItemStack stack) {
        return L2Backpack.loc("textures/block/ender_backpack.png");
    }

    @Override
    @Nullable
    public IItemHandler getInvCap(ItemStack storage, ServerPlayer player) {
        return new InvWrapper((Container)player.getEnderChestInventory());
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return InvTooltip.get(this, stack);
    }

    @Override
    public int getInvSize(ItemStack stack) {
        return 27;
    }

    @Override
    public List<ItemStack> getInvItems(ItemStack stack, Player player) {
        return ((EnderSyncCap)((PlayerCapabilityHolder)LBMisc.ENDER_SYNC.type()).getOrCreate((IAttachmentHolder)player)).getItems(player);
    }

    @Override
    @Nullable
    public IQuickSwapToken<?> getTokenOfType(ItemStack stack, LivingEntity entity, QuickSwapType type) {
        IQuickSwapToken iQuickSwapToken;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            iQuickSwapToken = ((PlayerCapabilityHolder)LBMisc.ENDER_SYNC.type()).getExisting((IAttachmentHolder)player).map(e -> e.getToken(player, type)).orElse(null);
        } else {
            iQuickSwapToken = null;
        }
        return iQuickSwapToken;
    }
}

