/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.drawer;

import dev.xkmc.l2backpack.content.drawer.IDrawerHandler;
import dev.xkmc.l2backpack.content.remote.common.EnderDrawerAccess;
import dev.xkmc.l2backpack.init.registrate.LBTriggers;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public record EnderDrawerItemHandler(EnderDrawerAccess access, boolean logistics) implements IDrawerHandler
{
    public int getSlots() {
        return 2;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot == 1) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)this.access.item(), this.access.getCount());
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!stack.isComponentsPatchEmpty() || stack.getItem() != this.access.item()) {
            return stack;
        }
        int count = this.access.getCount();
        int max = this.access.item().getDefaultMaxStackSize() * 64;
        int insert = Math.min(max - count, stack.getCount());
        if (!simulate) {
            this.access.setCount(count + insert);
            if (this.logistics && insert > 0) {
                this.access.getOwner().ifPresent(arg_0 -> ((PlayerTrigger)((PlayerTrigger)LBTriggers.REMOTE.get())).trigger(arg_0));
            }
        }
        return insert == stack.getCount() ? ItemStack.EMPTY : new ItemStack((ItemLike)this.access.item(), stack.getCount() - insert);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int count = this.access.getCount();
        int take = Math.min(count, amount);
        if (!simulate) {
            this.access.setCount(count - take);
            if (this.logistics && take > 0) {
                this.access.getOwner().ifPresent(arg_0 -> ((PlayerTrigger)((PlayerTrigger)LBTriggers.REMOTE.get())).trigger(arg_0));
            }
        }
        return new ItemStack((ItemLike)this.access.item(), take);
    }

    public int getSlotLimit(int slot) {
        return 64 * this.access.item().getDefaultMaxStackSize();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return stack.isComponentsPatchEmpty() && stack.getItem() == this.access.item();
    }
}

