/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.drawer;

import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.drawer.DrawerInvWrapper;
import dev.xkmc.l2backpack.content.insert.OverlayInsertItem;
import dev.xkmc.l2backpack.content.remote.common.EnderDrawerAccess;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerInvAccess;
import dev.xkmc.l2backpack.events.TooltipUpdateEvents;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.LBLang;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2backpack.init.registrate.LBTriggers;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class EnderDrawerItem
extends BlockItem
implements BaseDrawerItem {
    private static final ResourceLocation BG = L2Backpack.loc("textures/block/drawer/ender_side.png");

    public static Item getItem(ItemStack drawer) {
        return (Item)LBItems.DC_ENDER_DRAWER_ITEM.getOrDefault(drawer, (Object)Items.AIR);
    }

    public EnderDrawerItem(Block block, Item.Properties properties) {
        super(block, properties.stacksTo(1).fireResistant());
    }

    @Override
    public ItemStack getDrawerContent(ItemStack drawer) {
        return EnderDrawerItem.getItem(drawer).getDefaultInstance();
    }

    @Override
    public boolean canAccept(ItemStack drawer, ItemStack stack) {
        if (stack.getItem() instanceof OverlayInsertItem) {
            return false;
        }
        Item item = EnderDrawerItem.getItem(drawer);
        return stack.isComponentsPatchEmpty() && (item == Items.AIR || stack.getItem() == item);
    }

    void refresh(ItemStack drawer, Player player) {
        if (LBItems.DC_OWNER_ID.get(drawer) == null) {
            drawer.set(LBItems.DC_OWNER_ID, (Object)player.getUUID());
            drawer.set(LBItems.DC_OWNER_NAME, (Object)player.getName());
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (EnderDrawerItem.getItem(stack) == Items.AIR) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!(player instanceof ServerPlayer)) {
            ContentTransfer.playDrawerSound(player);
            return InteractionResultHolder.success((Object)stack);
        }
        ServerPlayer sp = (ServerPlayer)player;
        this.refresh(stack, player);
        if (!player.isShiftKeyDown()) {
            ItemStack take = this.takeItem(stack, sp);
            int c = take.getCount();
            player.getInventory().placeItemBackInInventory(take);
            ContentTransfer.onExtract(player, c, stack);
        } else {
            EnderDrawerAccess access = EnderDrawerAccess.of(world, stack);
            int count = access.getCount();
            ItemStack ins = access.item().getDefaultInstance();
            int max = this.getStacking(stack, ins);
            int ext = BaseDrawerItem.loadFromInventory(max, count, ins, player);
            access.setCount(count += ext);
            ContentTransfer.onCollect(player, ext, stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide() && context.getPlayer() != null) {
            this.refresh(context.getItemInHand(), context.getPlayer());
        }
        if (context.getItemInHand().get(LBItems.DC_OWNER_ID) == null) {
            return InteractionResult.FAIL;
        }
        if (EnderDrawerItem.getItem(context.getItemInHand()) == Items.AIR) {
            Player player;
            if (!context.getLevel().isClientSide() && (player = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage((Component)LBLang.IDS.NO_ITEM.get(new Object[0]).withStyle(ChatFormatting.RED), true);
            }
            return InteractionResult.FAIL;
        }
        if (context.getPlayer() != null && !context.getPlayer().isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        InteractionResult result = super.useOn(context);
        if (result == InteractionResult.FAIL) {
            return InteractionResult.PASS;
        }
        return result;
    }

    @Override
    public void insert(ItemStack drawer, ItemStack stack, Player player) {
        this.refresh(drawer, player);
        EnderDrawerAccess access = EnderDrawerAccess.of(player.level(), drawer);
        int count = access.getCount();
        int take = Math.min(this.getStacking(drawer, stack) - count, stack.getCount());
        access.setCount(access.getCount() + take);
        stack.shrink(take);
    }

    @Override
    public ItemStack takeItem(ItemStack drawer, int max, Player player, boolean simulate) {
        this.refresh(drawer, player);
        EnderDrawerAccess access = EnderDrawerAccess.of(player.level(), drawer);
        Item item = EnderDrawerItem.getItem(drawer);
        int take = Math.min(access.getCount(), Math.min(max, item.getDefaultMaxStackSize()));
        if (!simulate) {
            access.setCount(access.getCount() - take);
        }
        return new ItemStack((ItemLike)item, take);
    }

    @Override
    public boolean canSetNewItem(ItemStack drawer) {
        return EnderDrawerItem.getItem(drawer) == Items.AIR;
    }

    @Override
    public void setItem(ItemStack drawer, ItemStack item, Player player) {
        this.refresh(drawer, player);
        LBItems.DC_ENDER_DRAWER_ITEM.set(drawer, (Object)item.getItem());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        Component name;
        Item item = EnderDrawerItem.getItem(stack);
        UUID id = (UUID)LBItems.DC_OWNER_ID.get(stack);
        if (item != Items.AIR) {
            int count = id == null ? -1 : TooltipUpdateEvents.getCount(id, item);
            list.add((Component)LBLang.IDS.DRAWER_CONTENT.get(item.getDescription(), count < 0 ? "???" : Integer.valueOf(count)));
        }
        if ((name = (Component)LBItems.DC_OWNER_NAME.get(stack)) != null) {
            list.add((Component)LBLang.IDS.STORAGE_OWNER.get(name));
            PickupConfig.addText(stack, list);
        }
        LBLang.addInfo(flag, list, LBLang.Info.ENDER_DRAWER, LBLang.Info.EXTRACT_DRAWER, LBLang.Info.PLACE, LBLang.Info.COLLECT_DRAWER, LBLang.Info.ENDER_DRAWER_USE);
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public DrawerInvWrapper getCaps(ItemStack stack, @Nullable Void ignored) {
        return new DrawerInvWrapper(stack, trace -> LBItems.DC_OWNER_ID.get(stack) == null && trace.player == null ? null : new EnderDrawerInvAccess(stack, this, trace.level, trace.player));
    }

    @Override
    public void serverTrigger(ItemStack storage, ServerPlayer player) {
        UUID id = (UUID)LBItems.DC_OWNER_ID.get(storage);
        if (id != null && !id.equals(player.getUUID())) {
            ((PlayerTrigger)LBTriggers.SHARE.get()).trigger(player);
        }
    }

    @Override
    public ResourceLocation backgroundLoc() {
        return BG;
    }
}

