/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.drawer;

import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.drawer.IDrawerBlockEntity;
import dev.xkmc.l2backpack.content.remote.common.EnderDrawerAccess;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerItemHandler;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

@SerialClass
public class EnderDrawerBlockEntity
extends IDrawerBlockEntity {
    @SerialField
    public UUID ownerId = Util.NIL_UUID;
    @SerialField
    public Component ownerName = Component.empty();
    @SerialField
    public Item item = Items.AIR;
    @SerialField
    public PickupConfig config = PickupConfig.DEF;
    private boolean added = false;

    public EnderDrawerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public IItemHandler getItemHandler() {
        if (this.level == null || this.remove) {
            return null;
        }
        if (this.level.isClientSide()) {
            return new InvWrapper((Container)new SimpleContainer(64));
        }
        if (this.ownerId == null) {
            return null;
        }
        return new EnderDrawerItemHandler(this.getAccess(), true);
    }

    public EnderDrawerAccess getAccess() {
        return EnderDrawerAccess.of(this.level, this.ownerId, this.item);
    }

    public void onChunkUnloaded() {
        this.removeFromListener();
        super.onChunkUnloaded();
    }

    public void setRemoved() {
        this.removeFromListener();
        super.setRemoved();
    }

    public void onLoad() {
        super.onLoad();
        this.addToListener();
    }

    public void addToListener() {
        if (!this.added && this.level != null && !this.level.isClientSide() && this.ownerId != null) {
            this.added = true;
            this.getAccess().listener.add(this);
        }
    }

    public void removeFromListener() {
        if (this.added && this.level != null && !this.level.isClientSide() && this.ownerId != null) {
            this.added = false;
            this.getAccess().listener.remove((Object)this);
        }
    }

    @Override
    public ItemStack getItem() {
        return this.item.getDefaultInstance();
    }
}

