/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.dimensional;

import dev.xkmc.l2backpack.content.remote.common.LBSavedData;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalContainer;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalItem;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2backpack.init.registrate.LBTriggers;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record DimensionalMenuPvd(ServerPlayer player, ItemStack stack, DimensionalItem item) implements MenuProvider
{
    public Component getDisplayName() {
        return this.stack.getHoverName();
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        StorageContainer container = this.getContainer((ServerLevel)player.level()).get();
        if (!container.id.equals(player.getUUID())) {
            ((PlayerTrigger)LBTriggers.SHARE.get()).trigger((ServerPlayer)player);
        }
        return new DimensionalContainer(id, inventory, container.get(), container, null);
    }

    public Optional<StorageContainer> getContainer(ServerLevel level) {
        UUID id = (UUID)LBItems.DC_OWNER_ID.get(this.stack);
        long pwd = (Long)LBItems.DC_PASSWORD.getOrDefault(this.stack, (Object)0L);
        String lootStr = (String)LBItems.DC_LOOT_ID.get(this.stack);
        long seed = (Long)LBItems.DC_LOOT_SEED.getOrDefault(this.stack, (Object)0L);
        if (lootStr != null) {
            this.stack.remove(LBItems.DC_LOOT_ID);
            this.stack.remove(LBItems.DC_LOOT_SEED);
        }
        if (id == null) {
            return Optional.empty();
        }
        ResourceLocation loot = lootStr == null ? null : ResourceLocation.parse((String)lootStr);
        return LBSavedData.get(level).getOrCreateStorage(id, this.item.color.getId(), pwd, this.player, loot, seed);
    }

    public void open() {
        this.item.refresh(this.stack, (Player)this.player);
        if (this.player.level().isClientSide() || this.getContainer((ServerLevel)this.player.level()).isEmpty()) {
            return;
        }
        this.player.openMenu((MenuProvider)this);
    }
}

