/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.dimensional;

import dev.xkmc.l2backpack.content.backpack.BackpackMenu;
import dev.xkmc.l2backpack.content.click.DrawerQuickInsert;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalBlockEntity;
import dev.xkmc.l2backpack.init.registrate.LBMenu;
import dev.xkmc.l2core.base.menu.base.BaseContainerMenu;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DimensionalContainer
extends BaseContainerMenu<DimensionalContainer>
implements DrawerQuickInsert {
    protected final Player player;
    @Nullable
    protected final StorageContainer storage;
    @Nullable
    private final DimensionalBlockEntity activeChest;

    public static DimensionalContainer fromNetwork(MenuType<DimensionalContainer> type, int windowId, Inventory inv) {
        return new DimensionalContainer(windowId, inv, new SimpleContainer(54), null, null);
    }

    public DimensionalContainer(int windowId, Inventory inventory, SimpleContainer cont, @Nullable StorageContainer storage, @Nullable DimensionalBlockEntity entity) {
        super((MenuType)LBMenu.MT_WORLD_CHEST.get(), windowId, inventory, BackpackMenu.MANAGERS[5], menu -> cont, false);
        this.player = inventory.player;
        this.addSlot("grid", stack -> true);
        this.storage = storage;
        this.activeChest = entity;
    }

    public int getColor() {
        assert (this.storage != null);
        return this.storage.color;
    }

    public UUID getOwner() {
        assert (this.storage != null);
        return this.storage.id;
    }

    public boolean stillValid(Player player) {
        if (this.activeChest != null && !this.activeChest.stillValid(player)) {
            return false;
        }
        return this.storage != null;
    }

    public ItemStack quickMoveStack(Player pl, int id) {
        ItemStack stack = ((Slot)this.slots.get(id)).getItem();
        if (this.quickMove(pl, (AbstractContainerMenu)this, stack, id)) {
            ((Slot)this.slots.get(id)).setChanged();
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean quickMove(Player pl, AbstractContainerMenu menu, ItemStack stack, int id) {
        int n = this.container.getContainerSize();
        boolean moved = id >= 36 ? DrawerQuickInsert.moveItemStackTo(pl, (AbstractContainerMenu)this, stack, 0, 36, true) : DrawerQuickInsert.moveItemStackTo(pl, (AbstractContainerMenu)this, stack, 36, 36 + n, false);
        return moved;
    }
}

