/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.dimensional;

import dev.xkmc.l2backpack.content.capability.InvPickupCap;
import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.capability.PickupTrace;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalInvWrapper;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalItem;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DimensionalCaps
extends InvPickupCap<DimensionalInvWrapper> {
    private final ItemStack stack;

    public DimensionalCaps(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public PickupConfig getPickupMode() {
        return PickupConfig.get(this.stack);
    }

    @Override
    public int getSignature() {
        Item item = this.stack.getItem();
        if (item instanceof DimensionalItem) {
            DimensionalItem item2 = (DimensionalItem)item;
            int color = item2.color.ordinal();
            UUID id = (UUID)LBItems.DC_OWNER_ID.get(this.stack);
            if (id != null) {
                return id.hashCode() ^ color ^ 0x55AA;
            }
        }
        return 0;
    }

    @Override
    public DimensionalInvWrapper getInv(PickupTrace trace) {
        DimensionalItem item;
        Optional<StorageContainer> opt;
        Item item2 = this.stack.getItem();
        if (item2 instanceof DimensionalItem && (opt = (item = (DimensionalItem)item2).getContainer(this.stack, trace.level)).isPresent()) {
            StorageContainer storage = opt.get();
            return new DimensionalInvWrapper((Container)storage.get(), storage.id);
        }
        return null;
    }
}

