/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.dimensional;

import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.capability.PickupMode;
import dev.xkmc.l2backpack.content.remote.common.LBSavedData;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.dimensional.BlockPickupInvWrapper;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalContainer;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalInvWrapper;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2core.base.tile.BaseBlockEntity;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class DimensionalBlockEntity
extends BaseBlockEntity
implements MenuProvider,
Nameable,
ContainerListener {
    @SerialField
    public UUID ownerId;
    @SerialField
    public Component ownerName;
    @SerialField
    long password;
    @SerialField
    public int color;
    @SerialField
    public PickupConfig config = PickupConfig.DEF;
    protected Component name;
    private boolean added = false;

    public DimensionalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public IItemHandler getItemHandler() {
        if (this.level == null || this.remove) {
            return null;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return new InvWrapper((Container)new SimpleContainer(27));
        }
        ServerLevel sl = (ServerLevel)level;
        Optional<StorageContainer> storage = LBSavedData.get(sl).getOrCreateStorage(this.ownerId, this.color, this.password, null, null, 0L);
        if (storage.isEmpty()) {
            return null;
        }
        if (this.config == null || this.config.pickup() == PickupMode.NONE) {
            return new DimensionalInvWrapper((Container)storage.get().get(), this.ownerId);
        }
        return new BlockPickupInvWrapper(sl, this, storage.get(), this.config);
    }

    public void setColor(int color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.password = color;
        this.setChanged();
    }

    public Component getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.ownerName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int wid, Inventory inventory, Player player) {
        if (this.level == null || this.ownerId == null) {
            return null;
        }
        Optional<StorageContainer> storage = this.getAccess();
        if (storage.isEmpty()) {
            return null;
        }
        return new DimensionalContainer(wid, inventory, storage.get().get(), storage.get(), this);
    }

    public boolean stillValid(Player player) {
        assert (this.level != null);
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    private Optional<StorageContainer> getAccess() {
        assert (this.level != null);
        return LBSavedData.get((ServerLevel)this.level).getOrCreateStorage(this.ownerId, this.color, this.password, null, null, 0L);
    }

    public void onChunkUnloaded() {
        this.removeFromListener();
        super.onChunkUnloaded();
    }

    public void setRemoved() {
        this.removeFromListener();
        super.setRemoved();
    }

    public void onLoad() {
        super.onLoad();
        this.addToListener();
    }

    public void addToListener() {
        if (!this.added && this.level != null && !this.level.isClientSide() && this.ownerId != null) {
            this.added = true;
            this.getAccess().ifPresent(e -> e.get().addListener((ContainerListener)this));
        }
    }

    public void removeFromListener() {
        if (this.added && this.level != null && !this.level.isClientSide() && this.ownerId != null) {
            this.added = false;
            this.getAccess().ifPresent(e -> e.get().removeListener((ContainerListener)this));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput data) {
        super.applyImplicitComponents(data);
        this.name = (Component)data.get(DataComponents.CUSTOM_NAME);
        this.config = (PickupConfig)data.getOrDefault(LBItems.DC_PICKUP, (Object)PickupConfig.DEF);
        this.ownerId = (UUID)data.getOrDefault(LBItems.DC_OWNER_ID, (Object)Util.NIL_UUID);
        this.ownerName = (Component)data.getOrDefault(LBItems.DC_OWNER_NAME, (Object)Component.empty());
        this.password = (Long)data.getOrDefault(LBItems.DC_PASSWORD, (Object)0L);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder data) {
        super.collectImplicitComponents(data);
        data.set(LBItems.DC_PICKUP, (Object)this.config);
        data.set(LBItems.DC_OWNER_ID, (Object)this.ownerId);
        data.set(LBItems.DC_OWNER_NAME, (Object)this.ownerName);
        data.set(LBItems.DC_PASSWORD, (Object)this.password);
        data.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void containerChanged(Container p_18983_) {
        this.setChanged();
    }

    public void setPickupMode(PickupConfig click) {
        this.config = click;
        if (this.level != null) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
        this.sync();
        this.setChanged();
    }
}

