/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.dimensional;

import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalAnalogBlockEntity;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalBlockEntity;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalItem;
import dev.xkmc.l2backpack.content.tool.TweakerTool;
import dev.xkmc.l2backpack.init.registrate.LBBlocks;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2modularblock.mult.CreateBlockStateBlockMethod;
import dev.xkmc.l2modularblock.mult.DefaultStateBlockMethod;
import dev.xkmc.l2modularblock.mult.PlacementBlockMethod;
import dev.xkmc.l2modularblock.mult.SetPlacedByBlockMethod;
import dev.xkmc.l2modularblock.mult.UseItemOnBlockMethod;
import dev.xkmc.l2modularblock.one.BlockEntityBlockMethod;
import dev.xkmc.l2modularblock.one.GetBlockItemBlockMethod;
import dev.xkmc.l2modularblock.one.ShapeBlockMethod;
import dev.xkmc.l2modularblock.one.SpecialDropBlockMethod;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DimensionalBlock
implements CreateBlockStateBlockMethod,
DefaultStateBlockMethod,
PlacementBlockMethod,
UseItemOnBlockMethod,
GetBlockItemBlockMethod,
SpecialDropBlockMethod,
SetPlacedByBlockMethod,
ShapeBlockMethod {
    public static final DimensionalBlock INSTANCE = new DimensionalBlock();
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    public static final BlockEntityBlockMethod<DimensionalBlockEntity> TILE_ENTITY_SUPPLIER_BUILDER = new DimensionalAnalogBlockEntity<DimensionalBlockEntity>(LBBlocks.TE_DIMENSIONAL, DimensionalBlockEntity.class);
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOR});
    }

    public BlockState getDefaultState(BlockState state) {
        return (BlockState)state.setValue(COLOR, (Comparable)DyeColor.WHITE);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof DimensionalBlockEntity) {
            DimensionalBlockEntity chest = (DimensionalBlockEntity)blockentity;
            if (stack.getItem() instanceof TweakerTool) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            Item item = stack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                if (!level.isClientSide()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue(COLOR, (Comparable)dye.getDyeColor()));
                    chest.setColor(dye.getDyeColor().getId());
                } else {
                    ContentTransfer.playSound(player);
                }
                return ItemInteractionResult.SUCCESS;
            }
            BlockPos blockpos = pos.above();
            if (level.getBlockState(blockpos).isRedstoneConductor((BlockGetter)level, blockpos)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (level.isClientSide) {
                ContentTransfer.playSound(player);
                return ItemInteractionResult.SUCCESS;
            }
            player.openMenu((MenuProvider)chest);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof DimensionalBlockEntity) {
            DimensionalBlockEntity chest = (DimensionalBlockEntity)be;
            return DimensionalBlock.buildStack(state, chest);
        }
        return LBItems.DIMENSIONAL_STORAGE[((DyeColor)state.getValue(COLOR)).getId()].asStack();
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof DimensionalBlockEntity) {
            DimensionalBlockEntity chest = (DimensionalBlockEntity)blockentity;
            return List.of(DimensionalBlock.buildStack(state, chest));
        }
        return List.of(LBItems.DIMENSIONAL_STORAGE[((DyeColor)state.getValue(COLOR)).getId()].asStack());
    }

    public static ItemStack buildStack(BlockState state, DimensionalBlockEntity chest) {
        ItemStack stack = LBItems.DIMENSIONAL_STORAGE[((DyeColor)state.getValue(COLOR)).getId()].asStack();
        if (chest.ownerId != null) {
            stack.set(LBItems.DC_OWNER_ID, (Object)chest.ownerId);
            stack.set(LBItems.DC_OWNER_NAME, (Object)chest.ownerName);
            stack.set(LBItems.DC_PASSWORD, (Object)chest.password);
            stack.set(LBItems.DC_PICKUP, (Object)chest.config);
        }
        if (chest.name != null) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)chest.name);
        }
        return stack;
    }

    public BlockState getStateForPlacement(BlockState def, BlockPlaceContext context) {
        return (BlockState)def.setValue(COLOR, (Comparable)((DimensionalItem)context.getItemInHand().getItem()).color);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof DimensionalBlockEntity) {
            DimensionalBlockEntity chest = (DimensionalBlockEntity)blockentity;
            chest.setColor(((DyeColor)state.getValue(COLOR)).getId());
            chest.addToListener();
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

