/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.common;

import dev.xkmc.l2backpack.content.remote.common.LBSavedData;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerBlockEntity;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2core.util.ServerProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class EnderDrawerAccess {
    private final LBSavedData storage;
    private final UUID id;
    private final Item item;
    public final List<EnderDrawerBlockEntity> listener = new ArrayList<EnderDrawerBlockEntity>();

    public static EnderDrawerAccess of(Level level, ItemStack drawer) {
        UUID id = (UUID)LBItems.DC_OWNER_ID.getOrDefault(drawer, (Object)Util.NIL_UUID);
        Item item = (Item)LBItems.DC_ENDER_DRAWER_ITEM.getOrDefault(drawer, (Object)Items.AIR);
        return EnderDrawerAccess.of(level, id, item);
    }

    public static EnderDrawerAccess of(Level level, UUID id, Item item) {
        return LBSavedData.get((ServerLevel)level).getOrCreateDrawer(id, item);
    }

    EnderDrawerAccess(LBSavedData storage, UUID id, Item item) {
        this.storage = storage;
        this.id = id;
        this.item = item;
    }

    private HashMap<Item, Integer> getMap() {
        return this.storage.get((UUID)this.id).drawer;
    }

    public int getCount() {
        return this.getMap().computeIfAbsent(this.item, k -> 0);
    }

    public void setCount(int count) {
        this.getMap().put(this.item, count);
        this.listener.forEach(BlockEntity::setChanged);
    }

    public Item item() {
        return this.item;
    }

    public Optional<ServerPlayer> getOwner() {
        return ServerProxy.getServer().map(e -> e.getPlayerList().getPlayer(this.id));
    }
}

