/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.recipe;

import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.init.data.LBConfig;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2backpack.init.registrate.LBMisc;
import dev.xkmc.l2core.serial.recipe.AbstractSmithingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public class BackpackUpgradeRecipe
extends AbstractSmithingRecipe<BackpackUpgradeRecipe> {
    public BackpackUpgradeRecipe(Ingredient template, Ingredient base, Ingredient addition, ItemStack result) {
        super(template, base, addition, result);
    }

    public ItemStack getResultItem(HolderLookup.Provider pvd) {
        int init = LBConfig.SERVER.getSpec().isEmpty() ? ((Integer)LBConfig.SERVER.initialRows.getDefault()).intValue() : ((Integer)LBConfig.SERVER.initialRows.get()).intValue();
        return LBItems.DC_ROW.set(super.getResultItem(pvd).copy(), (Object)(init + 1));
    }

    public boolean matches(SmithingRecipeInput container, Level level) {
        if (!super.matches(container, level)) {
            return false;
        }
        ItemStack stack = container.getItem(1);
        BaseBagItem bag = (BaseBagItem)stack.getItem();
        return bag.getRows(stack) < 8;
    }

    public ItemStack assemble(SmithingRecipeInput container, HolderLookup.Provider access) {
        ItemStack stack = super.assemble(container, access);
        BaseBagItem bag = (BaseBagItem)stack.getItem();
        stack.set(LBItems.DC_ROW, (Object)(bag.getRows(stack) + 1));
        return stack;
    }

    public AbstractSmithingRecipe.Serializer<BackpackUpgradeRecipe> getSerializer() {
        return (AbstractSmithingRecipe.Serializer)LBMisc.RSC_BAG_UPGRADE.get();
    }
}

