/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.quickswap.type;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.single.Scabbard;
import dev.xkmc.l2backpack.content.quickswap.type.MatcherSwapType;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapType;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapTypes;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class QuickSwapManager {
    @Nullable
    public static QuickSwapType getValidType(LivingEntity player, boolean isAltDown) {
        if (!isAltDown) {
            for (MatcherSwapType e : QuickSwapTypes.MATCHER) {
                if (!e.match(player.getMainHandItem())) continue;
                return e;
            }
            for (MatcherSwapType e : QuickSwapTypes.MATCHER) {
                if (!e.allowsOffhand() || !e.match(player.getOffhandItem())) continue;
                return e;
            }
            if (Scabbard.isValidItem(player.getMainHandItem())) {
                return QuickSwapTypes.TOOL;
            }
            if (player.getMainHandItem().isEmpty()) {
                return QuickSwapTypes.ARMOR;
            }
            return null;
        }
        QuickSwapType main = QuickSwapManager.getValidType(player, player.getMainHandItem(), isAltDown);
        if (main != null) {
            return main;
        }
        for (MatcherSwapType e : QuickSwapTypes.MATCHER) {
            if (!e.allowsOffhand() || !e.match(player.getOffhandItem())) continue;
            return e;
        }
        return null;
    }

    @Nullable
    public static QuickSwapType getValidType(LivingEntity player, ItemStack focus, boolean isAltDown) {
        if (isAltDown && Scabbard.isValidItem(focus)) {
            return QuickSwapTypes.TOOL;
        }
        for (MatcherSwapType e : QuickSwapTypes.MATCHER) {
            if (!e.match(focus)) continue;
            return e;
        }
        if (isAltDown && focus.isEmpty() || Scabbard.isValidItem(focus)) {
            return QuickSwapTypes.TOOL;
        }
        if (focus.isEmpty()) {
            return QuickSwapTypes.ARMOR;
        }
        return null;
    }

    @Nullable
    public static IQuickSwapToken<?> getToken(LivingEntity user, boolean isAltDown) {
        return QuickSwapManager.getToken(user, null, isAltDown);
    }

    @Nullable
    public static IQuickSwapToken<?> getToken(LivingEntity user, @Nullable ItemStack focus, boolean isAltDown) {
        QuickSwapType type;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(user.getMainHandItem());
        list.add(user.getOffhandItem());
        list.add(user.getItemBySlot(EquipmentSlot.CHEST));
        Optional<Pair<ItemStack, PlayerSlot<?>>> opt = CuriosCompat.getSlot(user, stack -> stack.getItem() instanceof IQuickSwapItem);
        opt.ifPresent(pair -> list.add((ItemStack)pair.getFirst()));
        QuickSwapType quickSwapType = type = focus == null ? QuickSwapManager.getValidType(user, isAltDown) : QuickSwapManager.getValidType(user, focus, isAltDown);
        if (type == null) {
            return null;
        }
        for (ItemStack stack2 : list) {
            IQuickSwapItem item;
            IQuickSwapToken<?> token;
            Item item2 = stack2.getItem();
            if (!(item2 instanceof IQuickSwapItem) || (token = (item = (IQuickSwapItem)item2).getTokenOfType(stack2, user, type)) == null) continue;
            return token;
        }
        return null;
    }
}

