/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.quickswap.single;

import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.client.ItemOnBackItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapToken;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapType;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapTypes;
import dev.xkmc.l2backpack.init.data.LBLang;
import dev.xkmc.l2backpack.init.data.LBTagGen;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2library.util.GenericItemStack;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.Nullable;

public class Quiver
extends SingleSwapItem
implements ItemOnBackItem {
    public static float displayArrow(ItemStack stack) {
        int disp = 0;
        ItemContainerContents cont = (ItemContainerContents)LBItems.BACKPACK_CONTENT.get(stack);
        if (cont != null) {
            for (ItemStack arrow : cont.nonEmptyItems()) {
                if (arrow.isEmpty()) continue;
                ++disp;
            }
        }
        return disp == 0 ? 0.0f : (float)(Math.ceil((float)disp / 3.0f) + 0.5);
    }

    public static boolean isValidStack(ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems() && !stack.is(LBTagGen.BACKPACK_BLACKLIST) && stack.getItem() instanceof ArrowItem;
    }

    public Quiver(Item.Properties props) {
        super(props.stacksTo(1).fireResistant());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        PickupConfig.addText(stack, list);
        LBLang.addInfo(flag, list, LBLang.Info.ARROW_INFO, LBLang.Info.INHERIT);
    }

    @Override
    @Nullable
    public IQuickSwapToken<?> getTokenOfType(ItemStack stack, LivingEntity player, QuickSwapType type) {
        if (type != QuickSwapTypes.ARROW) {
            return null;
        }
        GenericItemStack bow = null;
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        if (main.getItem() instanceof ProjectileWeaponItem) {
            bow = GenericItemStack.of((ItemStack)main);
        } else if (off.getItem() instanceof ProjectileWeaponItem) {
            bow = GenericItemStack.of((ItemStack)off);
        }
        if (bow == null) {
            return null;
        }
        ItemContainerContents cont = (ItemContainerContents)LBItems.BACKPACK_CONTENT.get(stack);
        if (cont == null) {
            return null;
        }
        for (ItemStack arrow : cont.nonEmptyItems()) {
            if (!((ProjectileWeaponItem)bow.item()).getAllSupportedProjectiles(bow.stack()).test(arrow)) continue;
            return new SingleSwapToken(this, stack, QuickSwapTypes.ARROW);
        }
        return null;
    }

    @Override
    public boolean isValidContent(ItemStack stack) {
        return Quiver.isValidStack(stack);
    }
}

