/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.quickswap.single;

import dev.xkmc.l2backpack.content.client.ItemOnBackItem;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapToken;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapType;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapTypes;
import dev.xkmc.l2backpack.init.data.LBLang;
import dev.xkmc.l2backpack.init.data.LBTagGen;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ArmorSwap
extends SingleSwapItem
implements ItemOnBackItem {
    public static boolean isValidItem(ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems() && !stack.is(LBTagGen.BACKPACK_BLACKLIST) && !(stack.getItem() instanceof BaseBagItem) && ArmorSwap.getEquipmentSlotForItem(stack).getType() == EquipmentSlot.Type.HUMANOID_ARMOR;
    }

    public ArmorSwap(Item.Properties props) {
        super(props.stacksTo(1).fireResistant());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        LBLang.addInfo(flag, list, LBLang.Info.ARMORBAG_INFO, LBLang.Info.INHERIT);
    }

    @Override
    @Nullable
    public IQuickSwapToken<?> getTokenOfType(ItemStack stack, LivingEntity player, QuickSwapType type) {
        if (type != QuickSwapTypes.ARMOR) {
            return null;
        }
        return new SingleSwapToken(this, stack, type);
    }

    @Override
    public boolean isValidContent(ItemStack stack) {
        return ArmorSwap.isValidItem(stack);
    }
}

