/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.quickswap.handswap;

import dev.xkmc.l2backpack.content.common.BaseBagMenu;
import dev.xkmc.l2backpack.content.quickswap.handswap.HandswapItem;
import dev.xkmc.l2backpack.init.registrate.LBMenu;
import dev.xkmc.l2core.base.menu.base.SpriteManager;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HandswapMenu
extends BaseBagMenu<HandswapMenu> {
    public static final SpriteManager MANAGERS = new SpriteManager("l2backpack", "handswap");
    protected int[] vals = new int[9];

    public static HandswapMenu fromNetwork(MenuType<HandswapMenu> type, int windowId, Inventory inv, RegistryFriendlyByteBuf buf) {
        PlayerSlot slot = PlayerSlot.read((RegistryFriendlyByteBuf)buf);
        UUID id = buf.readUUID();
        return new HandswapMenu(windowId, inv, slot, id, null);
    }

    public HandswapMenu(int windowId, Inventory inventory, PlayerSlot<?> hand, UUID uuid, @Nullable Component title) {
        super((MenuType)LBMenu.MT_HAND.get(), windowId, inventory, MANAGERS, hand, uuid, 1);
        ItemStack stack = this.getStack();
        Item[] list = HandswapItem.getMatcher(stack);
        for (int i = 0; i < 9; ++i) {
            this.vals[i] = BuiltInRegistries.ITEM.getId((Object)list[i]);
            this.addDataSlot(DataSlot.shared((int[])this.vals, (int)i));
        }
    }

    public boolean clickMenuButton(Player player, int i) {
        if (i < 0 || i >= 9) {
            return false;
        }
        if (player.level().isClientSide()) {
            return true;
        }
        ItemStack stack = this.getStack();
        Item[] list = HandswapItem.getMatcher(stack);
        list[i] = Items.AIR;
        this.vals[i] = 0;
        HandswapItem.setMatcher(stack, list);
        return true;
    }

    public Slot getSlot(String name, int i, int j) {
        return super.getSlot(name, i, j);
    }

    public Item getMatcher(int i) {
        return (Item)BuiltInRegistries.ITEM.byId(this.vals[i]);
    }
}

