/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.quickswap.common;

import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapItem;
import dev.xkmc.l2backpack.content.quickswap.entry.SingleSwapEntry;
import dev.xkmc.l2backpack.content.quickswap.entry.SingleSwapHandler;
import dev.xkmc.l2backpack.content.quickswap.type.ISingleSwapAction;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapType;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SingleSwapToken(IQuickSwapItem item, ItemStack stack, QuickSwapType type) implements IQuickSwapToken<SingleSwapEntry>
{
    @Override
    public void setSelected(int slot) {
        SingleSwapItem.setSelected(this.stack, slot);
    }

    @Override
    public List<SingleSwapEntry> getList() {
        return SingleSwapEntry.parse(this, this.getRawList());
    }

    private List<ItemStack> getRawList() {
        return BaseBagItem.getItems(this.stack);
    }

    @Override
    public int getSelected() {
        return SingleSwapItem.getSelected(this.stack);
    }

    @Override
    public void shrink(int i) {
        List<ItemStack> list = this.getRawList();
        list.get(this.getSelected()).shrink(i);
        BaseBagItem.setItems(this.stack, list);
    }

    @Override
    public void swap(Player player) {
        QuickSwapType quickSwapType = this.type;
        if (!(quickSwapType instanceof ISingleSwapAction)) {
            return;
        }
        ISingleSwapAction action = (ISingleSwapAction)((Object)quickSwapType);
        List<ItemStack> list = this.getRawList();
        int i = this.getSelected();
        action.swapSingle(player, new SingleSwapHandler(list, i));
        BaseBagItem.setItems(this.stack, list);
    }

    @Override
    public boolean isLocked(int i) {
        return false;
    }
}

