/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.quickswap.common;

import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.common.ISetSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapItem;
import dev.xkmc.l2backpack.content.quickswap.entry.SetSwapEntry;
import dev.xkmc.l2backpack.content.quickswap.entry.SetSwapHandler;
import dev.xkmc.l2backpack.content.quickswap.type.ISetSwapAction;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapType;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SetSwapToken(ISetSwapItem item, ItemStack stack, QuickSwapType type) implements IQuickSwapToken<SetSwapEntry>
{
    @Override
    public void setSelected(int slot) {
        SingleSwapItem.setSelected(this.stack, slot);
    }

    @Override
    public List<SetSwapEntry> getList() {
        return SetSwapEntry.parse(this, BaseBagItem.getItems(this.stack), this.item.getRows());
    }

    private List<ItemStack> getRawList() {
        return BaseBagItem.getItems(this.stack);
    }

    @Override
    public int getSelected() {
        return SingleSwapItem.getSelected(this.stack);
    }

    @Override
    public void shrink(int i) {
        throw new UnsupportedOperationException("set swap does not support shrink");
    }

    @Override
    public void swap(Player player) {
        QuickSwapType quickSwapType = this.type;
        if (!(quickSwapType instanceof ISetSwapAction)) {
            return;
        }
        ISetSwapAction action = (ISetSwapAction)((Object)quickSwapType);
        List<ItemStack> list = this.getRawList();
        int row = list.size() / this.item.getRows();
        int ind = this.getSelected();
        action.swapSet(player, new SetSwapHandler(list, this::isLocked, i -> i * row + ind));
        BaseBagItem.setItems(this.stack, list);
    }

    @Override
    public boolean isLocked(int i) {
        return this.item.getToggle(this.stack, null).isLocked(i);
    }
}

