/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.quickswap.common;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2backpack.content.quickswap.common.EntryRenderContext;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.entry.ISwapEntry;
import dev.xkmc.l2backpack.content.quickswap.type.ISideInfoRenderer;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapManager;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapType;
import dev.xkmc.l2backpack.events.BackpackSel;
import dev.xkmc.l2backpack.init.data.LBConfig;
import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.l2itemselector.init.data.L2Keys;
import dev.xkmc.l2itemselector.overlay.SelectionSideBar;
import dev.xkmc.l2itemselector.overlay.SideBar;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class QuickSwapOverlay
extends SelectionSideBar<ISwapEntry<?>, BackpackSignature> {
    public static QuickSwapOverlay INSTANCE = new QuickSwapOverlay();

    public QuickSwapOverlay() {
        super(40.0f, 3.0f);
    }

    public boolean isScreenOn() {
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null) {
            return false;
        }
        return BackpackSel.INSTANCE.isClientActive((Player)player);
    }

    public static boolean hasShiftDown() {
        return L2Keys.hasShiftDown();
    }

    public static boolean hasAltDown() {
        return L2Keys.hasAltDown();
    }

    public boolean isOnHold() {
        return QuickSwapOverlay.hasShiftDown() || QuickSwapOverlay.hasAltDown() || L2Keys.SWAP.map.isDown();
    }

    public Pair<List<ISwapEntry<?>>, Integer> getItems() {
        LocalPlayer player = Proxy.getClientPlayer();
        assert (player != null);
        IQuickSwapToken<?> token = QuickSwapManager.getToken((LivingEntity)player, QuickSwapOverlay.hasAltDown());
        assert (token != null);
        List<?> list = token.getList();
        int selected = token.getSelected();
        return Pair.of((Object)((List)Wrappers.cast(list)), (Object)selected);
    }

    public static boolean activePopup(@Nullable QuickSwapType type) {
        return type != null && type.activePopup();
    }

    public BackpackSignature getSignature() {
        LocalPlayer player = Proxy.getClientPlayer();
        assert (player != null);
        IQuickSwapToken<?> token = QuickSwapManager.getToken((LivingEntity)player, QuickSwapOverlay.hasAltDown());
        assert (token != null);
        int selected = token.getSelected();
        boolean ignoreOther = false;
        QuickSwapType type = token.type();
        if (!this.isOnHold()) {
            ignoreOther = !QuickSwapOverlay.activePopup(type);
        }
        int focus = player.getInventory().selected;
        ItemStack sel = type.getSignatureItem((Player)player);
        return new BackpackSignature(selected, ignoreOther, type, focus, sel);
    }

    public boolean isAvailable(ISwapEntry<?> token) {
        LocalPlayer player = Proxy.getClientPlayer();
        assert (player != null);
        QuickSwapType type = token.token().type();
        return type.isAvailable((Player)player, token);
    }

    public boolean onCenter() {
        return (Boolean)LBConfig.CLIENT.previewOnCenter.get();
    }

    protected void renderEntry(SelectionSideBar.Context ctx, ISwapEntry<?> token, int i, int selected) {
        LocalPlayer player = Proxy.getClientPlayer();
        assert (player != null);
        QuickSwapType type = token.token().type();
        float progress = (this.max_ease - this.ease_time) / this.max_ease;
        type.renderSelected(ctx, (Player)player, token, new EntryRenderContext(i, progress, ctx.x0(), 18 * i + ctx.y0(), selected == i && this.ease_time == this.max_ease, this.onCenter()));
    }

    public void renderContent(SelectionSideBar.Context ctx) {
        super.renderContent(ctx);
        LocalPlayer player = Proxy.getClientPlayer();
        assert (player != null);
        Pair<List<ISwapEntry<?>>, Integer> pair = this.getItems();
        ISwapEntry hover = (ISwapEntry)((List)pair.getFirst()).get((Integer)pair.getSecond());
        QuickSwapType type = hover.token().type();
        if (this.ease_time == this.max_ease && type instanceof ISideInfoRenderer) {
            ISideInfoRenderer rtype = (ISideInfoRenderer)((Object)type);
            int x = ctx.x0();
            int y = 81 + ctx.y0();
            x = this.onCenter() ? (x -= 18) : (x += 18 * hover.asList().size());
            rtype.renderSide(ctx, x, y, (Player)player, hover);
        }
    }

    protected int getXOffset(int width) {
        float progress = (this.max_ease - this.ease_time) / this.max_ease;
        if (this.onCenter()) {
            return Math.round((float)width / 2.0f + 54.0f + 1.0f + progress * (float)width / 2.0f);
        }
        return Math.round((float)(width - 36) + progress * 20.0f);
    }

    protected int getYOffset(int height) {
        return height / 2 - 81 + 1;
    }

    public record BackpackSignature(int backpackSelect, boolean ignoreOther, @Nullable QuickSwapType type, int playerSelect, ItemStack stack) implements SideBar.Signature<BackpackSignature>
    {
        public boolean shouldRefreshIdle(SideBar<?> sideBar, @Nullable BackpackSignature old) {
            if (this.ignoreOther) {
                if (old == null) {
                    return false;
                }
                return old.type == this.type && old.backpackSelect != this.backpackSelect();
            }
            return !this.equals(old);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BackpackSignature)) {
                return false;
            }
            BackpackSignature sig = (BackpackSignature)obj;
            return this.backpackSelect == sig.backpackSelect && this.ignoreOther == sig.ignoreOther && this.type == sig.type && this.playerSelect == sig.playerSelect && ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)sig.stack);
        }
    }
}

