/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.insert;

import dev.xkmc.l2backpack.content.insert.OverlayInsertItem;
import dev.xkmc.l2backpack.network.ClickInteractToServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public interface CapInsertItem
extends OverlayInsertItem {
    default public boolean isValidContent(ItemStack carried) {
        return true;
    }

    @Override
    default public boolean clientInsert(ItemStack storage, ItemStack carried, int cid, Slot slot, boolean perform, int button, ClickInteractToServer.Callback suppress, int limit) {
        if (carried.isEmpty()) {
            return false;
        }
        if (!this.isValidContent(carried)) {
            return false;
        }
        if (perform) {
            this.sendInsertPacket(cid, carried, slot, suppress, limit);
        }
        return true;
    }

    @Nullable
    default public IItemHandler getInvCap(ItemStack storage, ServerPlayer player) {
        return (IItemHandler)storage.getCapability(Capabilities.ItemHandler.ITEM);
    }

    @Override
    default public void attemptInsert(ItemStack storage, ItemStack carried, ServerPlayer player) {
        if (!this.isValidContent(carried)) {
            return;
        }
        IItemHandler handler = this.getInvCap(storage, player);
        if (handler == null) {
            return;
        }
        ItemStack remain = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)carried.copy(), (boolean)false);
        carried.setCount(remain.getCount());
    }
}

