/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.drawer;

import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.click.DoubleClickItem;
import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.drawer.DrawerInvAccess;
import dev.xkmc.l2backpack.content.drawer.DrawerInvWrapper;
import dev.xkmc.l2backpack.content.insert.OverlayInsertItem;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.LBLang;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2core.util.DCStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class DrawerItem
extends BlockItem
implements BaseDrawerItem,
ContentTransfer.Quad,
DoubleClickItem {
    private static final ResourceLocation BG = L2Backpack.loc("textures/block/drawer/drawer_side.png");

    public static int getCount(ItemStack drawer) {
        return (Integer)LBItems.DC_DRAWER_COUNT.getOrDefault(drawer, (Object)0);
    }

    public static void setCount(ItemStack drawer, int count) {
        LBItems.DC_DRAWER_COUNT.set(drawer, (Object)count);
    }

    public DrawerItem(Block block, Item.Properties properties) {
        super(block, properties.stacksTo(1).fireResistant());
    }

    @Override
    public ItemStack getDrawerContent(ItemStack drawer) {
        ItemStack stack = ((DCStack)LBItems.DC_DRAWER_STACK.getOrDefault(drawer, (Object)new DCStack(ItemStack.EMPTY))).stack();
        int count = DrawerItem.getCount(drawer);
        return count == 0 ? ItemStack.EMPTY : stack;
    }

    @Override
    public void setItem(ItemStack drawer, ItemStack item, Player player) {
        if (item.isEmpty()) {
            drawer.remove(LBItems.DC_DRAWER_STACK);
            drawer.remove(LBItems.DC_DRAWER_COUNT);
        } else {
            LBItems.DC_DRAWER_STACK.set(drawer, (Object)new DCStack(item.copyWithCount(1)));
        }
    }

    @Override
    public boolean canAccept(ItemStack drawer, ItemStack stack) {
        if (!stack.getItem().canFitInsideContainerItems()) {
            return false;
        }
        if (stack.getItem() instanceof OverlayInsertItem) {
            return false;
        }
        ItemStack content = this.getDrawerContent(drawer);
        return content.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)content, (ItemStack)stack);
    }

    @Override
    public int getStacking(ItemStack drawer) {
        return BaseDrawerItem.super.getStacking(drawer) * (Integer)LBItems.DC_DRAWER_STACKING.getOrDefault(drawer, (Object)1);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack drawer = player.getItemInHand(hand);
        if (world.isClientSide()) {
            ContentTransfer.playDrawerSound(player);
            return InteractionResultHolder.success((Object)drawer);
        }
        if (!player.isShiftKeyDown()) {
            ItemStack item = this.getDrawerContent(drawer);
            int count = DrawerItem.getCount(drawer);
            int max = Math.min(item.getMaxStackSize(), count);
            player.getInventory().placeItemBackInInventory(item.copyWithCount(max));
            DrawerItem.setCount(drawer, count - max);
            ContentTransfer.onExtract(player, max, drawer);
        } else {
            boolean perform;
            ItemStack item = this.getDrawerContent(drawer);
            int count = DrawerItem.getCount(drawer);
            int max = this.getStacking(drawer, item);
            boolean bl = perform = !this.canSetNewItem(drawer);
            if (!perform && !(item = ContentTransfer.filterMaxItem((IItemHandler)new InvWrapper((Container)player.getInventory()))).isEmpty()) {
                perform = true;
                this.setItem(drawer, item, player);
            }
            if (perform) {
                int ext = BaseDrawerItem.loadFromInventory(max, count, item, player);
                DrawerItem.setCount(drawer, count += ext);
                ContentTransfer.onCollect(player, ext, drawer);
            }
        }
        return InteractionResultHolder.success((Object)drawer);
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult result = ContentTransfer.blockInteract(context, this);
        if (result == InteractionResult.PASS && context.getPlayer() != null && context.getPlayer().isShiftKeyDown() && (result = super.useOn(context)) == InteractionResult.FAIL) {
            result = InteractionResult.PASS;
        }
        return result;
    }

    @Override
    public void click(Player player, ItemStack stack, boolean client, boolean shift, boolean right, @Nullable IItemHandler target) {
        ItemStack item;
        if (!client && shift && right && target != null) {
            item = this.getDrawerContent(stack);
            int count = DrawerItem.getCount(stack);
            int remain = ContentTransfer.transfer(item, count, target);
            ContentTransfer.onDump(player, count - remain, stack);
            DrawerItem.setCount(stack, remain);
        } else if (client && shift && right && target != null) {
            ContentTransfer.playDrawerSound(player);
        }
        if (!client && shift && !right && target != null) {
            boolean perform;
            item = this.getDrawerContent(stack);
            boolean bl = perform = !this.canSetNewItem(stack);
            if (!perform && !(item = ContentTransfer.filterMaxItem(target)).isEmpty()) {
                this.setItem(stack, item, player);
                perform = true;
            }
            if (perform) {
                int count = DrawerItem.getCount(stack);
                int max = this.getStacking(stack, item);
                int remain = ContentTransfer.loadFrom(item, max - count, target);
                ContentTransfer.onLoad(player, remain, stack);
                DrawerItem.setCount(stack, count + remain);
            }
        } else if (client && shift && !right && target != null) {
            ContentTransfer.playDrawerSound(player);
        }
    }

    @Override
    public void insert(ItemStack drawer, ItemStack stack, @Nullable Player player) {
        int count = DrawerItem.getCount(drawer);
        int allow = Math.min(this.getStacking(drawer, stack) - count, stack.getCount());
        DrawerItem.setCount(drawer, count + allow);
        stack.shrink(allow);
    }

    @Override
    public ItemStack takeItem(ItemStack drawer, int max, @Nullable Player player, boolean simulate) {
        if (this.canSetNewItem(drawer)) {
            return ItemStack.EMPTY;
        }
        ItemStack item = this.getDrawerContent(drawer);
        int count = DrawerItem.getCount(drawer);
        int take = Math.min(count, Math.min(max, item.getMaxStackSize()));
        if (!simulate) {
            DrawerItem.setCount(drawer, count - take);
        }
        return item.copyWithCount(take);
    }

    @Override
    public boolean canSetNewItem(ItemStack drawer) {
        return this.getDrawerContent(drawer).isEmpty();
    }

    public void appendHoverText(ItemStack drawer, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        ItemStack content = this.getDrawerContent(drawer);
        int count = DrawerItem.getCount(drawer);
        if (!this.canSetNewItem(drawer)) {
            list.add((Component)LBLang.IDS.DRAWER_CONTENT.get(content.getHoverName(), count));
        }
        list.add((Component)LBLang.IDS.BACKPACK_SLOT.get(LBItems.DC_DRAWER_STACKING.getOrDefault(drawer, (Object)1), 8).withStyle(ChatFormatting.GRAY));
        PickupConfig.addText(drawer, list);
        LBLang.addInfo(flag, list, LBLang.Info.DRAWER_USE, LBLang.Info.LOAD, LBLang.Info.PLACE, LBLang.Info.EXTRACT_DRAWER, LBLang.Info.COLLECT_DRAWER, LBLang.Info.PICKUP);
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public DrawerInvWrapper getCaps(ItemStack stack, @Nullable Void ignored) {
        DrawerInvAccess access = new DrawerInvAccess(stack, this);
        return new DrawerInvWrapper(stack, trace -> access);
    }

    @Override
    public ResourceLocation backgroundLoc() {
        return BG;
    }

    @Override
    public int remainingSpace(ItemStack drawer) {
        if (this.canSetNewItem(drawer)) {
            return 0;
        }
        int count = DrawerItem.getCount(drawer);
        return this.getStacking(drawer, this.getDrawerContent(drawer)) - count;
    }

    @Override
    public boolean canAbsorb(Slot src, ItemStack stack) {
        if (this.canSetNewItem(stack)) {
            return false;
        }
        return this.canAccept(stack, src.getItem());
    }

    @Override
    public void mergeStack(ItemStack drawer, ItemStack stack) {
        int count = DrawerItem.getCount(drawer);
        int allow = Math.min(this.getStacking(drawer, stack) - count, stack.getCount());
        DrawerItem.setCount(drawer, count + allow);
        stack.shrink(allow);
    }
}

