/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.drawer;

import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.drawer.DrawerBlockEntity;
import dev.xkmc.l2backpack.content.drawer.IDrawerHandler;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@SerialClass
public class DrawerHandler
implements IDrawerHandler {
    @SerialField
    public ItemStack item = ItemStack.EMPTY;
    @SerialField
    public int count = 0;
    @SerialField
    public int stacking = 1;
    @SerialField
    public PickupConfig config = PickupConfig.DEF;
    private final DrawerBlockEntity parent;

    public DrawerHandler(DrawerBlockEntity parent) {
        this.parent = parent;
    }

    public int getSlots() {
        return 2;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        return this.item.copyWithCount(this.count);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int max = this.stacking * stack.getMaxStackSize();
        if (this.count >= max) {
            return stack;
        }
        if (this.item.isEmpty()) {
            int toInsert = Math.min(max, stack.getCount());
            if (!simulate) {
                this.item = stack.copyWithCount(1);
                this.count = toInsert;
                this.parent.sync();
            }
            if (toInsert == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            ItemStack ans = stack.copy();
            ans.setCount(stack.getCount() - toInsert);
            return ans;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.item, (ItemStack)stack)) {
            return stack;
        }
        int toInsert = Math.min(max - this.count, stack.getCount());
        if (!simulate) {
            this.item = stack.copyWithCount(1);
            this.count += toInsert;
            this.parent.sync();
        }
        if (toInsert == stack.getCount()) {
            return ItemStack.EMPTY;
        }
        ItemStack ans = stack.copy();
        ans.setCount(stack.getCount() - toInsert);
        return ans;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.item.isEmpty() || this.count == 0) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, this.count);
        ItemStack ans = this.item.copyWithCount(toExtract);
        if (!simulate) {
            this.count -= toExtract;
            if (this.count == 0) {
                this.item = ItemStack.EMPTY;
            }
            this.parent.sync();
        }
        return ans;
    }

    public int getSlotLimit(int slot) {
        return this.stacking * this.item.getMaxStackSize();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.item.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.item);
    }
}

