/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.drawer;

import dev.xkmc.l2backpack.content.capability.PickupBagItem;
import dev.xkmc.l2backpack.content.insert.OverlayInsertItem;
import dev.xkmc.l2backpack.init.advancement.DrawerInteractTrigger;
import dev.xkmc.l2backpack.init.registrate.LBTriggers;
import dev.xkmc.l2backpack.network.ClickInteractToServer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public interface BaseDrawerItem
extends PickupBagItem,
OverlayInsertItem {
    public static final int MAX_FACTOR = 8;
    public static final int STACKING = 64;

    public boolean canAccept(ItemStack var1, ItemStack var2);

    public ItemStack getDrawerContent(ItemStack var1);

    public static int loadFromInventory(int max, int count, ItemStack item, Player player) {
        int ext = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack inv_stack = (ItemStack)player.getInventory().items.get(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)inv_stack)) continue;
            int take = Math.min(max - count, inv_stack.getCount());
            ext += take;
            inv_stack.shrink(take);
            if ((count += take) == max) break;
        }
        return ext;
    }

    default public int getStacking(ItemStack drawer) {
        return 64;
    }

    default public int getStacking(ItemStack drawer, ItemStack content) {
        return this.getStacking(drawer) * content.getMaxStackSize();
    }

    public void insert(ItemStack var1, ItemStack var2, Player var3);

    public void setItem(ItemStack var1, ItemStack var2, Player var3);

    @Override
    default public ItemStack takeItem(ItemStack drawer, ServerPlayer player) {
        ItemStack stack = this.takeItem(drawer, Integer.MAX_VALUE, (Player)player, false);
        if (!stack.isEmpty()) {
            ((DrawerInteractTrigger)((Object)LBTriggers.DRAWER.get())).trigger(player, ClickInteractToServer.Type.TAKE);
        }
        return stack;
    }

    public ItemStack takeItem(ItemStack var1, int var2, Player var3, boolean var4);

    public boolean canSetNewItem(ItemStack var1);

    @Override
    default public boolean clientInsert(ItemStack storage, ItemStack carried, int cid, Slot slot, boolean perform, int button, ClickInteractToServer.Callback suppress, int limit) {
        if (carried.isEmpty()) {
            return false;
        }
        if (!this.canAccept(storage, carried)) {
            return false;
        }
        if (perform) {
            this.sendInsertPacket(cid, carried, slot, suppress, limit);
        }
        return true;
    }

    @Override
    default public boolean mayClientTake() {
        return true;
    }

    @Override
    default public void attemptInsert(ItemStack storage, ItemStack carried, ServerPlayer player) {
        if (carried.isEmpty()) {
            return;
        }
        if (!this.canAccept(storage, carried)) {
            return;
        }
        if (this.canSetNewItem(storage)) {
            this.setItem(storage, carried, (Player)player);
        }
        this.insert(storage, carried, (Player)player);
        ((DrawerInteractTrigger)((Object)LBTriggers.DRAWER.get())).trigger(player, ClickInteractToServer.Type.INSERT);
    }

    public ResourceLocation backgroundLoc();
}

