/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.drawer;

import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.capability.PickupMode;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public interface BaseDrawerInvAccess
extends IItemHandlerModifiable {
    public BaseDrawerItem drawerItem();

    public ItemStack drawerStack();

    public ServerPlayer player();

    public int getStoredCount();

    public boolean isEmpty();

    default public ItemStack getStoredItem() {
        return this.drawerItem().getDrawerContent(this.drawerStack());
    }

    default public ItemStack getStoredStack() {
        if (this.isEmpty() || this.getStoredCount() == 0) {
            return ItemStack.EMPTY;
        }
        return this.getStoredItem().copyWithCount(this.getStoredCount());
    }

    default public void setStoredItem(ItemStack item) {
        this.drawerItem().setItem(this.drawerStack(), item, (Player)this.player());
    }

    public void setStoredCount(int var1);

    default public boolean isItemValid(ItemStack stack) {
        return this.drawerItem().canAccept(this.drawerStack(), stack);
    }

    default public int getSlots() {
        return 1;
    }

    default public int getSlotLimit(int slot) {
        return this.drawerItem().getStacking(this.drawerStack(), this.getStoredItem());
    }

    default public int getMax(ItemStack stack) {
        return this.drawerItem().getStacking(this.drawerStack(), stack);
    }

    default public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isItemValid(stack);
    }

    default public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.setStoredItem(stack);
        this.setStoredCount(stack.getCount());
    }

    @NotNull
    default public ItemStack getStackInSlot(int slot) {
        return this.getStoredStack();
    }

    @NotNull
    default public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        if (!this.isItemValid(stack)) {
            return stack;
        }
        boolean empty = this.isEmpty();
        int current = empty ? 0 : this.getStoredCount();
        int input = stack.getCount();
        int allow = Math.min(this.getMax(stack) - current, input);
        if (!simulate) {
            if (empty) {
                this.setStoredItem(stack);
            }
            this.setStoredCount(current + allow);
        }
        if (input == allow) {
            return ItemStack.EMPTY;
        }
        return stack.copyWithCount(input - allow);
    }

    @NotNull
    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.drawerItem().takeItem(this.drawerStack(), amount, (Player)this.player(), simulate);
    }

    default public boolean mayStack(BaseDrawerInvAccess inv, int slot, ItemStack stack, PickupConfig config) {
        return (config.pickup() == PickupMode.ALL || !this.isEmpty()) && this.isItemValid(stack);
    }
}

