/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.common;

import dev.xkmc.l2backpack.content.client.DrawerCountDeco;
import dev.xkmc.l2backpack.content.common.InvTooltip;
import dev.xkmc.l2core.util.Proxy;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record InvClientTooltip(InvTooltip inv) implements ClientTooltipComponent
{
    public int getHeight() {
        return this.inv.item().getInvSize(this.inv.stack()) / this.inv.item().getRowSize() * 18 + 2;
    }

    public int getWidth(Font font) {
        return 18 * this.inv.item().getRowSize();
    }

    public void renderImage(Font font, int mx, int my, GuiGraphics g) {
        List<ItemStack> list = this.inv.item().getInvItems(this.inv.stack(), (Player)Proxy.getClientPlayer());
        for (int i = 0; i < list.size(); ++i) {
            this.renderSlot(font, mx + i % this.inv.item().getRowSize() * 18, my + i / this.inv.item().getRowSize() * 18, g, list.get(i));
        }
    }

    private void renderSlot(Font font, int x, int y, GuiGraphics g, ItemStack stack) {
        this.blit(g, x, y);
        if (stack.isEmpty()) {
            return;
        }
        DrawerCountDeco.startTooltipRendering();
        g.renderItem(stack, x + 1, y + 1, 0);
        g.renderItemDecorations(font, stack, x + 1, y + 1);
        DrawerCountDeco.stopTooltipRendering();
    }

    private void blit(GuiGraphics g, int x, int y) {
        g.blitSprite(ResourceLocation.withDefaultNamespace((String)"container/bundle/slot"), x, y, 18, 20);
    }
}

