/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.common;

import dev.xkmc.l2backpack.content.drawer.IDrawerHandler;
import dev.xkmc.l2backpack.init.advancement.BagInteractTrigger;
import dev.xkmc.l2backpack.init.data.LBLang;
import dev.xkmc.l2backpack.init.registrate.LBTriggers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class ContentTransfer {
    public static int transfer(List<ItemStack> list, IItemHandler cap) {
        int n = list.size();
        int count = 0;
        for (int i = 0; i < n; ++i) {
            ItemStack stack = list.get(i);
            count += stack.getCount();
            stack = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)stack, (boolean)false);
            count -= stack.getCount();
            list.set(i, stack);
        }
        return count;
    }

    public static int transfer(ItemStack item, int count, IItemHandler cap) {
        int maxSize;
        int n = maxSize = cap instanceof IDrawerHandler ? count : item.getMaxStackSize();
        while (count > 0) {
            int step = Math.min(maxSize, count);
            ItemStack toInsert = item.copyWithCount(step);
            ItemStack remainer = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)toInsert, (boolean)false);
            count = count - step + remainer.getCount();
            if (remainer.isEmpty()) continue;
            return count;
        }
        return 0;
    }

    public static int loadFrom(List<ItemStack> list, IItemHandler cap, Player player, Predicate<ItemStack> pred) {
        int i;
        SimpleContainer cont = new SimpleContainer(list.toArray(new ItemStack[0]));
        InvWrapper handler = new InvWrapper((Container)cont);
        int n = cap.getSlots();
        int count = 0;
        block0: for (i = 0; i < n; ++i) {
            ItemStack stack;
            while (!(stack = cap.getStackInSlot(i)).isEmpty() && pred.test(stack)) {
                if (!stack.isStackable()) {
                    boolean hasSpace = false;
                    for (int j = 0; j < list.size(); ++j) {
                        if (!cont.getItem(j).isEmpty()) continue;
                        hasSpace = true;
                        break;
                    }
                    if (!hasSpace) continue block0;
                    ItemStack removal = cap.extractItem(i, 1, false);
                    ItemStack error = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)removal, (boolean)false);
                    if (!error.isEmpty()) {
                        player.drop(error, true);
                        continue block0;
                    }
                    ++count;
                    continue block0;
                }
                int maxAttempt = Math.min(stack.getCount(), stack.getMaxStackSize());
                ItemStack removalSim = cap.extractItem(i, maxAttempt, true);
                ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)removalSim, (boolean)true);
                if (removalSim.getCount() == remain.getCount()) continue block0;
                ItemStack removalReal = cap.extractItem(i, removalSim.getCount() - remain.getCount(), false);
                ItemStack error = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)removalReal, (boolean)false);
                count += removalReal.getCount() - error.getCount();
                if (!error.isEmpty()) {
                    player.drop(error, true);
                }
                if (error.isEmpty() && removalReal.getCount() == maxAttempt) continue;
                continue block0;
            }
        }
        for (i = 0; i < list.size(); ++i) {
            list.set(i, cont.getItem(i));
        }
        return count;
    }

    public static int loadFrom(ItemStack item, int space, IItemHandler cap) {
        int n = cap.getSlots();
        int count = 0;
        for (int i = 0; i < n; ++i) {
            ItemStack stack;
            if (space <= 0) {
                return count;
            }
            while (!(stack = cap.getStackInSlot(i)).isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack)) {
                int allow = Math.min(space, Math.min(stack.getMaxStackSize(), stack.getCount()));
                ItemStack removal = cap.extractItem(i, allow, false);
                int toRemove = removal.getCount();
                count += toRemove;
                if ((space -= toRemove) > 0) continue;
                return count;
            }
        }
        return count;
    }

    public static InteractionResult blockInteract(UseOnContext context, Quad item) {
        Player player = context.getPlayer();
        if (player != null) {
            BlockPos pos = context.getClickedPos();
            IItemHandler cap = (IItemHandler)context.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)context.getClickedFace());
            if (cap != null) {
                item.click(player, context.getItemInHand(), context.getLevel().isClientSide(), player.isShiftKeyDown(), true, cap);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void leftClick(Quad load, Level level, BlockPos pos, ItemStack stack, Player player, @Nullable Direction dir) {
        if (dir == null) {
            dir = Direction.UP;
        }
        IItemHandler cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)dir);
        load.click(player, stack, level.isClientSide(), player.isShiftKeyDown(), false, cap);
    }

    public static void onDump(Player player, int count, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.sendSystemMessage((Component)LBLang.IDS.DUMP_FEEDBACK.get(count), true);
            ((BagInteractTrigger)((Object)LBTriggers.INTERACT.get())).trigger(serverPlayer, stack, BagInteractTrigger.Type.DUMP, count);
        }
    }

    public static void onLoad(Player player, int count, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (count > 0) {
                serverPlayer.sendSystemMessage((Component)LBLang.IDS.LOAD_FEEDBACK.get(count), true);
                ((BagInteractTrigger)((Object)LBTriggers.INTERACT.get())).trigger(serverPlayer, stack, BagInteractTrigger.Type.LOAD, count);
            }
        }
    }

    public static void onExtract(Player player, int count, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.sendSystemMessage((Component)LBLang.IDS.EXTRACT_FEEDBACK.get(count), true);
            ((BagInteractTrigger)((Object)LBTriggers.INTERACT.get())).trigger(serverPlayer, stack, BagInteractTrigger.Type.EXTRACT, count);
        }
    }

    public static void onCollect(Player player, int count, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.sendSystemMessage((Component)LBLang.IDS.COLLECT_FEEDBACK.get(count), true);
            ((BagInteractTrigger)((Object)LBTriggers.INTERACT.get())).trigger(serverPlayer, stack, BagInteractTrigger.Type.COLLECT, count);
        }
    }

    public static void playSound(Player player) {
        player.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 1.0f, 1.0f);
    }

    public static void playDrawerSound(Player player) {
        player.playSound(SoundEvents.AMETHYST_BLOCK_PLACE, 1.0f, 1.0f);
    }

    public static ItemStack filterMaxItem(IItemHandler target) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        for (int i = 0; i < target.getSlots(); ++i) {
            ItemStack stack = target.getStackInSlot(i);
            map.compute(stack, (k, v) -> (v == null ? 0 : v) + stack.getCount());
        }
        ItemStack max = ItemStack.EMPTY;
        int count = 0;
        for (Map.Entry ent : map.entrySet()) {
            if ((Integer)ent.getValue() <= count) continue;
            max = (ItemStack)ent.getKey();
            count = (Integer)ent.getValue();
        }
        return max;
    }

    public static interface Quad {
        public void click(Player var1, ItemStack var2, boolean var3, boolean var4, boolean var5, @Nullable IItemHandler var6);
    }
}

