/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.common;

import dev.xkmc.l2backpack.content.click.DrawerQuickInsert;
import dev.xkmc.l2backpack.content.common.BagSlot;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.common.BaseBagItemHandler;
import dev.xkmc.l2backpack.content.remote.player.EnderSyncCap;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2backpack.init.registrate.LBMisc;
import dev.xkmc.l2core.base.menu.base.BaseContainerMenu;
import dev.xkmc.l2core.base.menu.base.SpriteManager;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2menustacker.screen.base.L2MSReg;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import dev.xkmc.l2menustacker.screen.source.SimpleSlotData;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public abstract class BaseBagMenu<T extends BaseBagMenu<T>>
extends BaseContainerMenu<T>
implements DrawerQuickInsert {
    protected final Player player;
    public final PlayerSlot<?> item_slot;
    protected final UUID uuid;
    protected final IItemHandlerModifiable handler;
    protected final int row;
    private ItemStack stack_cache = ItemStack.EMPTY;

    public BaseBagMenu(MenuType<T> type, int windowId, Inventory inventory, SpriteManager manager, PlayerSlot<?> hand, UUID uuid, int row) {
        super(type, windowId, inventory, manager, menu -> new SimpleContainer(0), false);
        this.item_slot = hand;
        this.uuid = uuid;
        this.player = inventory.player;
        this.row = row;
        ItemStack stack = this.getStack();
        if (stack.getItem() instanceof BaseBagItem) {
            IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (inv instanceof BaseBagItemHandler) {
                    BaseBagItemHandler bag = (BaseBagItemHandler)inv;
                    bag.attachEnv(sp, hand);
                }
            }
            this.handler = (IItemHandlerModifiable)inv;
        } else {
            this.handler = new InvWrapper((Container)new SimpleContainer(row * 9));
        }
        this.addSlots();
        if (!this.player.level().isClientSide()) {
            BaseBagItem.checkLootGen(this.getStack(), this.player);
        }
    }

    protected void addSlots() {
        this.addSlot("grid");
    }

    protected BagSlot createSlot(int index, int x, int y) {
        return new BagSlot(this.handler, index, x, y);
    }

    protected void addSlot(String name) {
        this.getLayout().getSlot(name, (x, y) -> this.createSlot(this.added++, x, y), (x$0, x$1, x$2, x$3) -> this.addSlot(x$0, x$1, x$2, x$3));
    }

    public void broadcastChanges() {
        if (!this.stillValid(this.player)) {
            return;
        }
        super.broadcastChanges();
    }

    public boolean stillValid(Player player) {
        ItemStack oldStack = this.stack_cache;
        ItemStack newStack = this.getStackRaw();
        return !this.getStackRaw().isEmpty() && oldStack == newStack;
    }

    public ItemStack getStack() {
        ItemStack stack = this.getStackRaw();
        if (stack.isEmpty()) {
            return this.stack_cache;
        }
        return stack;
    }

    private ItemStack getStackRaw() {
        ItemStack stack = this.accessSlot(this.player);
        if (this.player.level().isClientSide()) {
            return stack;
        }
        UUID id = (UUID)LBItems.DC_CONT_ID.get(stack);
        if (id == null || !id.equals(this.uuid)) {
            return ItemStack.EMPTY;
        }
        this.stack_cache = stack;
        return stack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ItemStack accessSlot(Player player) {
        Record record;
        if (!player.level().isClientSide() || this.item_slot.type() != L2MSReg.IS_ENDER.get() || !((record = this.item_slot.data()) instanceof SimpleSlotData)) return this.item_slot.getItem(player);
        SimpleSlotData simpleSlotData = (SimpleSlotData)record;
        try {
            int n;
            int slot = n = simpleSlotData.slot();
            return ((EnderSyncCap)((PlayerCapabilityHolder)LBMisc.ENDER_SYNC.type()).getOrCreate((IAttachmentHolder)player)).getItems(player).get(slot);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public ItemStack quickMoveStack(Player pl, int id) {
        ItemStack stack = ((Slot)this.slots.get(id)).getItem();
        if (this.quickMove(pl, (AbstractContainerMenu)this, stack, id)) {
            ((Slot)this.slots.get(id)).set(stack);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean quickMove(Player pl, AbstractContainerMenu menu, ItemStack stack, int id) {
        int n = this.handler.getSlots();
        boolean moved = id >= 36 ? DrawerQuickInsert.moveItemStackTo(pl, (AbstractContainerMenu)this, stack, 0, 36, true) : DrawerQuickInsert.moveItemStackTo(pl, (AbstractContainerMenu)this, stack, 36, 36 + n, false);
        return moved;
    }

    public void removed(Player player) {
        super.removed(player);
    }
}

