/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.common;

import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.remote.common.LBSavedData;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.restore.DimensionSourceData;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;

public class BaseBagItemHandler
extends ComponentItemHandler {
    private final BaseBagItem bag;
    private final ItemStack stack;
    private CallbackData callbackData = null;

    public BaseBagItemHandler(ItemStack parent) {
        super((MutableDataComponentHolder)parent, (DataComponentType)LBItems.BACKPACK_CONTENT.get(), 0);
        this.bag = (BaseBagItem)parent.getItem();
        this.stack = parent;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.stack.isEmpty() || slot < 0 || slot >= this.getSlots()) {
            return ItemStack.EMPTY;
        }
        return super.getStackInSlot(slot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.stack.isEmpty() || slot < 0 || slot >= this.getSlots()) {
            return;
        }
        super.setStackInSlot(slot, stack);
    }

    public ItemStack insertItem(int slot, ItemStack toInsert, boolean simulate) {
        if (this.stack.isEmpty() || slot < 0 || slot >= this.getSlots()) {
            return toInsert;
        }
        return super.insertItem(slot, toInsert, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.stack.isEmpty() || slot < 0 || slot >= this.getSlots()) {
            return ItemStack.EMPTY;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public int getSlots() {
        return this.bag.getRows(this.stack) * 9;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.isEmpty() || this.bag.isItemValid(slot, stack);
    }

    protected void onContentsChanged(int slot, ItemStack oldStack, ItemStack newStack) {
        super.onContentsChanged(slot, oldStack, newStack);
        this.saveCallback();
    }

    public void attachEnv(ServerPlayer player, PlayerSlot<?> hand) {
        Record record = hand.data();
        if (record instanceof DimensionSourceData) {
            DimensionSourceData data = (DimensionSourceData)record;
            this.callbackData = new CallbackData(this, player, data);
        }
    }

    private void saveCallback() {
        if (this.callbackData == null) {
            return;
        }
        this.callbackData.setChanged();
    }

    private record CallbackData(BaseBagItemHandler parent, ServerPlayer player, DimensionSourceData data) {
        private void setChanged() {
            Optional<StorageContainer> opt = LBSavedData.get(this.player.serverLevel()).getStorageWithoutPassword(this.data.uuid(), this.data.color());
            if (opt.isEmpty()) {
                return;
            }
            StorageContainer cont = opt.get();
            ItemStack slot = cont.get().getItem(this.data.slot());
            if (this.parent.stack != slot) {
                this.parent.callbackData = null;
                return;
            }
            cont.get().setChanged();
        }
    }
}

