/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.common;

import dev.xkmc.l2backpack.content.capability.PickupBagItem;
import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.common.InvTooltip;
import dev.xkmc.l2backpack.content.common.TooltipInvItem;
import dev.xkmc.l2backpack.content.insert.InsertOnlyItem;
import dev.xkmc.l2backpack.init.data.LBTagGen;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBagItem
extends Item
implements ContentTransfer.Quad,
PickupBagItem,
InsertOnlyItem,
TooltipInvItem {
    public static List<ItemStack> getItems(ItemStack stack) {
        BaseBagItem item = (BaseBagItem)stack.getItem();
        NonNullList list = NonNullList.withSize((int)(item.getRows(stack) * 9), (Object)ItemStack.EMPTY);
        ItemContainerContents cont = (ItemContainerContents)LBItems.BACKPACK_CONTENT.get(stack);
        if (cont != null) {
            cont.copyInto(list);
        }
        return list;
    }

    public static void setItems(ItemStack stack, List<ItemStack> list) {
        stack.set(LBItems.BACKPACK_CONTENT, (Object)ItemContainerContents.fromItems(list));
    }

    public BaseBagItem(Item.Properties props) {
        super(props);
    }

    public static void checkLootGen(ItemStack stack, Player player) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (LBItems.BACKPACK_CONTENT.get(stack) != null) {
            return;
        }
        String lootStr = (String)LBItems.DC_LOOT_ID.get(stack);
        if (lootStr == null) {
            return;
        }
        ResourceLocation rl = ResourceLocation.parse((String)lootStr);
        long seed = (Long)LBItems.DC_LOOT_SEED.getOrDefault(stack, (Object)0L);
        stack.remove(LBItems.DC_LOOT_ID);
        stack.remove(LBItems.DC_LOOT_SEED);
        LootTable loottable = sl.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)rl));
        LootParams.Builder builder = new LootParams.Builder(sl);
        builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
        BaseBagItem bag = (BaseBagItem)stack.getItem();
        SimpleContainer cont = new SimpleContainer(bag.getRows(stack));
        loottable.fill((Container)cont, builder.create(LootContextParamSets.EMPTY), seed);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < cont.getContainerSize(); ++i) {
            list.add(cont.getItem(i));
        }
        BaseBagItem.setItems(stack, list);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            int slot = hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : 40;
            this.open((ServerPlayer)player, PlayerSlot.ofInventory((int)slot), stack);
        } else {
            ContentTransfer.playSound(player);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        return ContentTransfer.blockInteract(context, this);
    }

    @Override
    public void click(Player player, ItemStack stack, boolean client, boolean shift, boolean right, @Nullable IItemHandler target) {
        ItemContainerContents cont;
        NonNullList list = NonNullList.withSize((int)(this.getRows(stack) * 9), (Object)ItemStack.EMPTY);
        if (!client && shift && target != null && (cont = (ItemContainerContents)LBItems.BACKPACK_CONTENT.get(stack)) != null) {
            cont.copyInto(list);
        }
        if (!client && shift && right && target != null) {
            int moved = ContentTransfer.transfer((List<ItemStack>)list, target);
            BaseBagItem.setItems(stack, (List<ItemStack>)list);
            ContentTransfer.onDump(player, moved, stack);
        } else if (client && shift && right && target != null) {
            ContentTransfer.playSound(player);
        }
        if (!client && shift && !right && target != null) {
            int moved = ContentTransfer.loadFrom((List<ItemStack>)list, target, player, this::isValidContent);
            BaseBagItem.setItems(stack, (List<ItemStack>)list);
            ContentTransfer.onLoad(player, moved, stack);
        } else if (client && shift && !right && target != null) {
            ContentTransfer.playSound(player);
        }
    }

    @Override
    public boolean isValidContent(ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems() && !stack.is(LBTagGen.BACKPACK_BLACKLIST);
    }

    public abstract void open(ServerPlayer var1, PlayerSlot<?> var2, ItemStack var3);

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return armorType == EquipmentSlot.CHEST;
    }

    @Nonnull
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return InvTooltip.get(this, stack);
    }

    public int getRows(ItemStack stack) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isValidContent(stack);
    }

    @Override
    public int getInvSize(ItemStack stack) {
        return this.getRows(stack) * 9;
    }

    @Override
    public List<ItemStack> getInvItems(ItemStack stack, Player player) {
        return BaseBagItem.getItems(stack);
    }

    public void checkInit(ItemStack stack) {
        if (LBItems.DC_CONT_ID.get(stack) == null) {
            stack.set(LBItems.DC_CONT_ID, (Object)UUID.randomUUID());
        }
        if (LBItems.BACKPACK_CONTENT.get(stack) == null) {
            stack.set(LBItems.BACKPACK_CONTENT, (Object)ItemContainerContents.EMPTY);
        }
    }
}

