/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.client;

import dev.xkmc.l2backpack.content.client.BackpackLayerRenderer;
import dev.xkmc.l2backpack.content.client.ItemOnBackLayerRenderer;
import dev.xkmc.l2backpack.init.L2Backpack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

public class RenderEvents {
    private static final String REG_NAME = "backpack";
    public static final ModelLayerLocation BACKPACK_LAYER = new ModelLayerLocation(L2Backpack.loc("backpack"), "main");

    public static void registerBackpackLayer(EntityRenderersEvent.AddLayers event) {
        LivingEntityRenderer ler;
        EntityRenderer entityRenderer;
        for (PlayerSkin.Model e : event.getSkins()) {
            entityRenderer = event.getSkin(e);
            if (!(entityRenderer instanceof LivingEntityRenderer)) continue;
            ler = (LivingEntityRenderer)entityRenderer;
            RenderEvents.addLayer(ler);
        }
        for (PlayerSkin.Model e : event.getEntityTypes()) {
            entityRenderer = event.getRenderer((EntityType)e);
            if (!(entityRenderer instanceof LivingEntityRenderer) || !((ler = (LivingEntityRenderer)entityRenderer).getModel() instanceof HumanoidModel)) continue;
            RenderEvents.addLayer(ler);
        }
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void addLayer(LivingEntityRenderer<T, M> ler) {
        Minecraft mc = Minecraft.getInstance();
        ItemInHandRenderer ir = mc.getEntityRenderDispatcher().getItemInHandRenderer();
        ler.addLayer(new BackpackLayerRenderer<T, M>(ler, mc.getEntityModels()));
        ler.addLayer(new ItemOnBackLayerRenderer<T, M>(ler, mc.getEntityModels(), ir));
    }
}

