/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.l2backpack.content.client.BackpackLayerRenderer;
import dev.xkmc.l2backpack.content.client.BackpackModel;
import dev.xkmc.l2backpack.content.client.DrawerCountDeco;
import dev.xkmc.l2backpack.content.common.BackpackModelItem;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.drawer.DrawerItem;
import dev.xkmc.l2backpack.init.registrate.LBBlocks;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class LBBEWLR
extends BlockEntityWithoutLevelRenderer {
    public static final Supplier<BlockEntityWithoutLevelRenderer> INSTANCE = Suppliers.memoize(() -> new LBBEWLR(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()));
    public static final IClientItemExtensions EXTENSIONS = new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return INSTANCE.get();
        }
    };
    private static final RandomSource random = RandomSource.create((long)42L);
    private final BackpackModel<LivingEntity> model;

    public LBBEWLR(BlockEntityRenderDispatcher dispatcher, EntityModelSet set) {
        super(dispatcher, set);
        this.model = new BackpackModel(set.bakeLayer(BackpackLayerRenderer.MLL));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext type, PoseStack pose, MultiBufferSource bufferSource, int light, int overlay) {
        Object item;
        Item item2 = stack.getItem();
        if (item2 instanceof BaseDrawerItem) {
            item = (BaseDrawerItem)item2;
            LBBEWLR.renderDrawer((BaseDrawerItem)item, stack, type, pose, bufferSource, light, overlay);
        }
        if ((item2 = stack.getItem()) instanceof BackpackModelItem) {
            item = (BackpackModelItem)item2;
            pose.pushPose();
            this.transformBackpack(pose, type);
            this.renderBackpack((BackpackModelItem)item, stack, bufferSource, pose, light);
            pose.popPose();
        }
    }

    private void transformBackpack(PoseStack pose, ItemDisplayContext type) {
        float size;
        switch (type) {
            case GUI: {
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                pose.translate(0.3, 0.9, 0.6);
                float size2 = 0.3f;
                pose.scale(size2, size2, size2);
                pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
                pose.mulPose(Axis.XP.rotationDegrees(-10.0f));
                pose.mulPose(Axis.YP.rotationDegrees(-250.0f));
                return;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                pose.translate(0.7, 0.9, 0.6);
                float size3 = 0.3f;
                pose.scale(size3, size3, size3);
                pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
                pose.mulPose(Axis.XP.rotationDegrees(-10.0f));
                pose.mulPose(Axis.YP.rotationDegrees(250.0f));
                return;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                pose.translate(0.25, 0.4, 0.5);
                size = 0.625f;
                pose.scale(size, size, size);
                break;
            }
            case GROUND: {
                pose.translate(0.8, 0.0, 0.6);
                size = 0.6f;
                pose.scale(size, size, size);
                pose.mulPose(Axis.XP.rotationDegrees(30.0f));
                pose.mulPose(Axis.YP.rotationDegrees(-180.0f));
                break;
            }
            case NONE: 
            case HEAD: 
            case FIXED: {
                pose.translate(0.5, 0.5, 0.7);
                float size4 = 0.8f;
                pose.scale(size4, -size4, size4);
                pose.translate(0.0, -0.6, 0.0);
                return;
            }
        }
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        pose.mulPose(Axis.XP.rotationDegrees(-30.0f));
        pose.mulPose(Axis.YP.rotationDegrees(225.0f));
        size = 0.65f;
        pose.scale(size, size, size);
        pose.translate(0.8, -1.75, 0.7);
    }

    private void renderBackpack(BackpackModelItem item, ItemStack stack, MultiBufferSource bufferSource, PoseStack pose, int light) {
        ResourceLocation texture = item.getModelTexture(stack);
        VertexConsumer vc = bufferSource.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)texture));
        this.model.body.getChild("main_body").render(pose, vc, light, OverlayTexture.NO_OVERLAY);
    }

    public static void renderDrawer(BaseDrawerItem drawer, ItemStack stack, ItemDisplayContext type, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.pushPose();
        ItemStack item = drawer.getDrawerContent(stack);
        int count = stack.getItem() instanceof DrawerItem ? DrawerItem.getCount(stack) : 1;
        ItemStack inv = item.copyWithCount(count);
        if (inv.isEmpty() || !DrawerCountDeco.showContent() || type != ItemDisplayContext.GUI) {
            BlockState state = LBBlocks.ENDER_DRAWER.getDefaultState();
            if (stack.getItem() instanceof DrawerItem) {
                state = LBBlocks.DRAWER.getDefaultState();
            }
            BakedModel model = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(state);
            model = model.applyTransform(type, poseStack, false);
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            ModelBlockRenderer renderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
            PoseStack.Pose pose = poseStack.last();
            random.setSeed(42L);
            for (RenderType rt : model.getRenderTypes(state, random, ModelData.EMPTY)) {
                renderer.renderModel(pose, bufferSource.getBuffer(ClientHooks.getEntityRenderType((RenderType)rt, (boolean)false)), state, model, 1.0f, 1.0f, 1.0f, light, overlay, ModelData.EMPTY, rt);
            }
            LBBEWLR.renderItemInside(inv, item.getItem() instanceof BlockItem ? 0.5 : 0.625, poseStack, type, bufferSource, light, overlay);
        } else {
            boolean flat;
            ItemRenderer r = Minecraft.getInstance().getItemRenderer();
            boolean bl = flat = !r.getModel(inv, null, null, 0).usesBlockLight();
            if (flat) {
                Lighting.setupForFlatItems();
            }
            r.renderStatic(inv, type, light, overlay, poseStack, bufferSource, null, 0);
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource bf = (MultiBufferSource.BufferSource)bufferSource;
                bf.endBatch();
            }
            if (flat) {
                Lighting.setupFor3DItems();
            }
        }
        poseStack.popPose();
    }

    public static void renderItemInside(ItemStack stack, double height, PoseStack matrix, ItemDisplayContext type, MultiBufferSource buffer, int light, int overlay) {
        Minecraft mc = Minecraft.getInstance();
        float time = (mc.getTimer().getGameTimeDeltaPartialTick(true) + (float)mc.level.getGameTime()) % 80.0f;
        if (!stack.isEmpty()) {
            matrix.pushPose();
            matrix.translate(0.5, height, 0.5);
            matrix.scale(2.0f, 2.0f, 2.0f);
            matrix.translate(0.0f, -0.2f, 0.0f);
            matrix.mulPose(Axis.YP.rotationDegrees(time * 4.5f));
            ItemRenderer r = Minecraft.getInstance().getItemRenderer();
            Lighting.setupForFlatItems();
            r.renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, matrix, buffer, null, 0);
            Lighting.setupFor3DItems();
            matrix.popPose();
        }
    }
}

