/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.client;

import dev.xkmc.l2backpack.content.capability.PickupMode;
import dev.xkmc.l2backpack.content.drawer.DrawerBlockEntity;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalBlockEntity;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerBlockEntity;
import dev.xkmc.l2backpack.events.TooltipUpdateEvents;
import dev.xkmc.l2backpack.init.data.LBLang;
import dev.xkmc.l2core.util.Proxy;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EnderPreviewOverlay
implements LayeredDraw.Layer {
    public void render(GuiGraphics g, DeltaTracker delta) {
        LocalPlayer player = Proxy.getClientPlayer();
        HitResult ray = Minecraft.getInstance().hitResult;
        if (!(ray instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult bray = (BlockHitResult)ray;
        BlockPos pos = bray.getBlockPos();
        BlockEntity entity = player.level().getBlockEntity(pos);
        int count = 0;
        Item item = Items.AIR;
        if (entity instanceof EnderDrawerBlockEntity) {
            EnderDrawerBlockEntity drawer = (EnderDrawerBlockEntity)entity;
            count = TooltipUpdateEvents.getCount(drawer.ownerId, drawer.item);
            item = drawer.getItem().getItem();
        } else if (entity instanceof DrawerBlockEntity) {
            DrawerBlockEntity drawer = (DrawerBlockEntity)entity;
            count = drawer.handler.count;
            item = drawer.getItem().getItem();
        }
        Font font = Minecraft.getInstance().font;
        if (item != Items.AIR) {
            MutableComponent text = LBLang.IDS.DRAWER_CONTENT.get(item.getDescription(), count < 0 ? "???" : Integer.valueOf(count));
            EnderPreviewOverlay.renderText(font, g, g.guiWidth() / 2, g.guiHeight() / 2 + 16, (Component)text);
        }
        if (entity instanceof DimensionalBlockEntity) {
            DimensionalBlockEntity be = (DimensionalBlockEntity)entity;
            if (be.config != null && be.config.pickup() != PickupMode.NONE) {
                Objects.requireNonNull(font);
                int off = 9;
                EnderPreviewOverlay.renderText(font, g, g.guiWidth() / 2, g.guiHeight() / 2 + 16, (Component)be.config.pickup().getTooltip());
                EnderPreviewOverlay.renderText(font, g, g.guiWidth() / 2, g.guiHeight() / 2 + 16 + off, (Component)be.config.destroy().getTooltip());
            }
        }
    }

    private static void renderText(Font font, GuiGraphics g, int x, int y, Component text) {
        g.drawString(font, text, x -= font.width((FormattedText)text) / 2, y, -1);
    }
}

