/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.client;

import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.drawer.DrawerItem;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerItem;
import dev.xkmc.l2backpack.init.data.LBConfig;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.IItemDecorator;

public class DrawerCountDeco
implements IItemDecorator {
    private static int renderTooltipContent = 0;

    public static void startTooltipRendering() {
        ++renderTooltipContent;
    }

    public static void stopTooltipRendering() {
        renderTooltipContent = 0;
    }

    public static boolean showContent() {
        if (((Boolean)LBConfig.CLIENT.drawerAlwaysRenderFlat.get()).booleanValue()) {
            return true;
        }
        if (renderTooltipContent > 0) {
            return true;
        }
        return Screen.hasShiftDown() || Screen.hasControlDown() || Screen.hasAltDown();
    }

    public boolean render(GuiGraphics g, Font font, ItemStack stack, int x, int y) {
        BaseDrawerItem item;
        String s;
        Item item2 = stack.getItem();
        if (item2 instanceof BaseDrawerItem && !(s = DrawerCountDeco.getCount(item = (BaseDrawerItem)item2, stack)).isEmpty()) {
            g.pose().pushPose();
            if (DrawerCountDeco.showContent()) {
                this.drawBG(g, item, x, y);
            }
            int height = DrawerCountDeco.getZ();
            int width = font.width(s);
            int x0 = Math.max(3, 17 - width);
            g.pose().translate((float)(x + x0), (float)(y + 16), (float)height);
            if (width > 14) {
                float sc = 14.0f / (float)width;
                g.pose().scale(sc, sc, 1.0f);
            }
            int col = -129;
            g.drawString(font, s, 0, -7, col);
            g.pose().popPose();
            return true;
        }
        return false;
    }

    private void drawBG(GuiGraphics g, BaseDrawerItem item, int x, int y) {
        g.blit(item.backgroundLoc(), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static String getCount(BaseDrawerItem item, ItemStack stack) {
        if (item.canSetNewItem(stack)) {
            return "";
        }
        if (item instanceof DrawerItem) {
            int count = DrawerItem.getCount(stack);
            if (count == 0) {
                return "";
            }
            if (count <= 999) {
                return "" + count;
            }
            return count / 1000 + "k";
        }
        if (item instanceof EnderDrawerItem) {
            return DrawerCountDeco.showContent() ? "?" : "";
        }
        return "";
    }

    private static int getZ() {
        return 250;
    }
}

