/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.click;

import dev.xkmc.l2backpack.content.bag.AbstractBag;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface DrawerQuickInsert {
    public static boolean moveItemStackTo(Player pl, AbstractContainerMenu menu, ItemStack stack, int start, int end, boolean reverse) {
        return DrawerQuickInsert.moveItemStackTo(pl, menu, stack, start, end, reverse, false);
    }

    public static boolean moveItemStackTo(Player pl, AbstractContainerMenu menu, ItemStack stack, int start, int end, boolean reverse, boolean split) {
        boolean changed = false;
        changed |= DrawerQuickInsert.doMerge(pl, menu, stack, start, end, reverse, false);
        changed |= DrawerQuickInsert.doMerge(pl, menu, stack, start, end, reverse, true);
        if (!stack.isEmpty()) {
            changed |= DrawerQuickInsert.doTake(pl, menu, stack, start, end, reverse, split);
        }
        return changed;
    }

    private static boolean doMerge(Player pl, AbstractContainerMenu menu, ItemStack stack, int start, int end, boolean reverse, boolean allowEmpty) {
        boolean changed = false;
        int i = start;
        if (reverse) {
            i = end - 1;
        }
        while (!stack.isEmpty() && !(!reverse ? i >= end : i < start)) {
            Slot slot = (Slot)menu.slots.get(i);
            ItemStack content = slot.getItem();
            if (DrawerQuickInsert.tryMerge(pl, stack, content, slot, allowEmpty)) {
                slot.set(content);
                changed = true;
            }
            if (reverse) {
                --i;
                continue;
            }
            ++i;
        }
        return changed;
    }

    private static boolean doTake(Player pl, AbstractContainerMenu menu, ItemStack stack, int start, int end, boolean reverse, boolean split) {
        boolean changed = false;
        int i = reverse ? end - 1 : start;
        while (!(!reverse ? i >= end : i < start)) {
            Slot slot = (Slot)menu.slots.get(i);
            if (DrawerQuickInsert.tryTake(pl, stack, slot.getItem(), slot, split)) {
                changed = true;
                break;
            }
            if (reverse) {
                --i;
                continue;
            }
            ++i;
        }
        return changed;
    }

    private static boolean tryMerge(Player pl, ItemStack src, ItemStack dst, Slot slot, boolean allowEmpty) {
        if (dst.isEmpty()) {
            return false;
        }
        Item item = dst.getItem();
        if (item instanceof AbstractBag) {
            AbstractBag bag = (AbstractBag)item;
            if (pl instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)pl;
                if (bag.isValidContent(src)) {
                    int count = src.getCount();
                    bag.attemptInsert(dst, src, sp);
                    return count != src.getCount();
                }
            }
        }
        if (pl instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)pl;
            Item count = dst.getItem();
            if (count instanceof BaseDrawerItem) {
                BaseDrawerItem item2 = (BaseDrawerItem)count;
                if (!allowEmpty && item2.canSetNewItem(dst)) {
                    return false;
                }
                int count2 = src.getCount();
                item2.attemptInsert(dst, src, sp);
                return count2 != src.getCount();
            }
        }
        if (src.isStackable() && ItemStack.isSameItemSameComponents((ItemStack)src, (ItemStack)dst)) {
            int maxSize;
            int j = dst.getCount() + src.getCount();
            if (j <= (maxSize = Math.min(slot.getMaxStackSize(), src.getMaxStackSize()))) {
                src.setCount(0);
                dst.setCount(j);
                return true;
            }
            if (dst.getCount() < maxSize) {
                src.shrink(maxSize - dst.getCount());
                dst.setCount(maxSize);
                return true;
            }
        }
        return false;
    }

    private static boolean tryTake(Player pl, ItemStack src, ItemStack dst, Slot slot, boolean split) {
        if (!dst.isEmpty()) {
            return false;
        }
        if (split && pl instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)pl;
            Item item = src.getItem();
            if (item instanceof BaseDrawerItem) {
                BaseDrawerItem item2 = (BaseDrawerItem)item;
                ItemStack content = item2.takeItem(src, slot.getMaxStackSize(), (Player)sp, true);
                if (slot.mayPlace(content)) {
                    item2.takeItem(src, slot.getMaxStackSize(), (Player)sp, false);
                    slot.setByPlayer(content);
                    slot.setChanged();
                    return true;
                }
                return false;
            }
        }
        if (slot.mayPlace(src)) {
            if (src.getCount() > slot.getMaxStackSize()) {
                slot.setByPlayer(src.split(slot.getMaxStackSize()));
            } else {
                slot.setByPlayer(src.split(src.getCount()));
            }
            slot.setChanged();
            return true;
        }
        return false;
    }

    public boolean quickMove(Player var1, AbstractContainerMenu var2, ItemStack var3, int var4);
}

