/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.capability;

import dev.xkmc.l2backpack.content.capability.DestroyMode;
import dev.xkmc.l2backpack.content.capability.PickupMode;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public record PickupConfig(PickupMode pickup, DestroyMode destroy) {
    public static final PickupConfig DEF = new PickupConfig(PickupMode.NONE, DestroyMode.NONE);

    public static PickupConfig get(ItemStack stack) {
        return (PickupConfig)LBItems.DC_PICKUP.getOrDefault(stack, (Object)DEF);
    }

    public static void addText(ItemStack stack, List<Component> list) {
        PickupConfig mode = PickupConfig.get(stack);
        list.add((Component)mode.pickup().getTooltip());
        list.add((Component)mode.destroy().getTooltip());
    }

    public static void iterateMode(ItemStack stack) {
        PickupConfig mode = PickupConfig.get(stack);
        stack.set(LBItems.DC_PICKUP, (Object)mode.iterateMode());
    }

    public static void iterateDestroy(ItemStack stack) {
        PickupConfig mode = PickupConfig.get(stack);
        stack.set(LBItems.DC_PICKUP, (Object)mode.iterateDestroy());
    }

    public PickupConfig iterateMode() {
        PickupMode next = PickupMode.values()[(this.pickup().ordinal() + 1) % PickupMode.values().length];
        return new PickupConfig(next, this.destroy);
    }

    public PickupConfig iterateDestroy() {
        DestroyMode next = DestroyMode.values()[(this.destroy().ordinal() + 1) % DestroyMode.values().length];
        return new PickupConfig(this.pickup, next);
    }
}

