/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.capability;

import dev.xkmc.l2backpack.content.capability.DestroyMode;
import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.capability.PickupMode;
import dev.xkmc.l2backpack.content.capability.PickupModeCap;
import dev.xkmc.l2backpack.content.capability.PickupTrace;
import dev.xkmc.l2backpack.init.registrate.LBMisc;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public abstract class InvPickupCap<T extends IItemHandlerModifiable>
implements PickupModeCap {
    @Nullable
    public abstract T getInv(PickupTrace var1);

    public boolean isValid(ItemStack stack) {
        return true;
    }

    public boolean mayStack(T inv, int slot, ItemStack stack, PickupConfig config) {
        if (!this.isValid(stack)) {
            return false;
        }
        ItemStack old = inv.getStackInSlot(slot);
        if (old.getCapability(LBMisc.PICKUP) != null) {
            return false;
        }
        if (config.pickup() == PickupMode.ALL && old.isEmpty()) {
            return true;
        }
        if (config.destroy() == DestroyMode.MATCH) {
            return stack.getItem() == old.getItem();
        }
        return ItemStack.isSameItemSameComponents((ItemStack)old, (ItemStack)stack);
    }

    @Override
    public int doPickup(ItemStack stack, PickupTrace trace) {
        if (!this.isValid(stack)) {
            return 0;
        }
        if (stack.isEmpty() || this.getPickupMode().pickup() == PickupMode.NONE) {
            return 0;
        }
        if (!trace.push(this.getSignature(), this.getPickupMode())) {
            return 0;
        }
        int ans = this.doPickupInternal(stack, trace);
        trace.pop();
        return ans;
    }

    private int doPickupInternal(ItemStack stack, PickupTrace trace) {
        T inv = this.getInv(trace);
        if (inv == null) {
            return 0;
        }
        int ans = 0;
        PickupMode pickup = trace.getMode().pickup();
        DestroyMode destroy = trace.getMode().destroy();
        if (pickup == PickupMode.NONE) {
            return ans;
        }
        boolean doClear = false;
        if (destroy == DestroyMode.ALL) {
            doClear = true;
        } else {
            for (int i = 0; i < inv.getSlots() && !stack.isEmpty(); ++i) {
                PickupModeCap opt;
                if (this.mayStack(inv, i, stack, trace.getMode())) {
                    boolean empty = inv.getStackInSlot(i).isEmpty();
                    if (!doClear && empty || destroy.attemptInsert) {
                        int count = stack.getCount();
                        ItemStack result = inv.insertItem(i, stack.copy(), trace.simulate);
                        int remain = result.getCount();
                        stack.setCount(remain);
                        ans += count - remain;
                    }
                    if (empty || destroy == DestroyMode.NONE) continue;
                    doClear = true;
                    continue;
                }
                ItemStack slot = inv.getStackInSlot(i);
                if (slot.isEmpty() || (opt = (PickupModeCap)slot.getCapability(LBMisc.PICKUP)) == null) continue;
                int taken = opt.doPickup(stack, trace);
                ans += taken;
                if (taken <= 0 || trace.simulate) continue;
                inv.setStackInSlot(i, slot);
            }
        }
        if (pickup == PickupMode.ALL && destroy == DestroyMode.EXCESS) {
            doClear = true;
        }
        if (doClear) {
            ans += stack.getCount();
            stack.setCount(0);
        }
        return ans;
    }
}

