/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.bag;

import dev.xkmc.l2backpack.content.bag.AbstractBag;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public record FastBagItemHandler(AbstractBag bag, ItemStack bagStack, NonNullList<ItemStack> list) implements IItemHandlerModifiable
{
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.list.set(slot, (Object)stack);
        this.bag.setContent(this.bagStack, this.list);
    }

    public int getSlots() {
        return 64;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.list.get(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (((ItemStack)this.list.get(slot)).isEmpty()) {
            if (!simulate) {
                this.list.set(slot, (Object)stack);
                this.bag.setContent(this.bagStack, this.list);
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack ans = (ItemStack)this.list.get(slot);
        if (!ans.isEmpty() && !simulate) {
            this.list.set(slot, (Object)ItemStack.EMPTY);
            this.bag.setContent(this.bagStack, this.list);
        }
        return ans;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.bag.isValidContent(stack);
    }
}

