/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.bag;

import dev.xkmc.l2backpack.content.bag.AbstractBag;
import dev.xkmc.l2backpack.content.bag.FastBagItemHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public record BagItemHandler(AbstractBag bag, ItemStack bagStack) implements IItemHandlerModifiable
{
    public BagItemHandler(ItemStack stack) {
        this((AbstractBag)stack.getItem(), stack);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        NonNullList<ItemStack> list = this.bag.getContent(this.bagStack);
        list.set(slot, (Object)stack);
        this.bag.setContent(this.bagStack, list);
    }

    public int getSlots() {
        return 64;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.bag.getContent(this.bagStack).get(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        NonNullList<ItemStack> list = this.bag.getContent(this.bagStack);
        if (((ItemStack)list.get(slot)).isEmpty()) {
            if (!simulate) {
                list.set(slot, (Object)stack);
                this.bag.setContent(this.bagStack, list);
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        NonNullList<ItemStack> list = this.bag.getContent(this.bagStack);
        ItemStack ans = (ItemStack)list.get(slot);
        if (!ans.isEmpty() && !simulate) {
            list.set(slot, (Object)ItemStack.EMPTY);
            this.bag.setContent(this.bagStack, list);
        }
        return ans;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.bag.isValidContent(stack);
    }

    public FastBagItemHandler toFast() {
        return new FastBagItemHandler(this.bag, this.bagStack, this.bag.getContent(this.bagStack));
    }
}

