/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.backpack;

import dev.xkmc.l2backpack.content.backpack.BackpackMenu;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public final class BackpackMenuPvd
implements MenuProvider {
    private final ServerPlayer player;
    private final PlayerSlot<?> slot;
    private final ItemStack stack;
    private final BaseBagItem bag;

    public BackpackMenuPvd(ServerPlayer player, PlayerSlot<?> slot, BaseBagItem item, ItemStack stack) {
        this.player = player;
        this.slot = slot;
        this.stack = stack;
        this.bag = item;
    }

    public Component getDisplayName() {
        return this.stack.getHoverName();
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        UUID uuid = (UUID)LBItems.DC_CONT_ID.getOrDefault(this.stack, (Object)Util.NIL_UUID);
        return new BackpackMenu(id, inventory, this.slot, uuid, this.bag.getRows(this.stack), this.getDisplayName());
    }

    public void writeBuffer(RegistryFriendlyByteBuf buf) {
        this.slot.write(buf);
        buf.writeUUID((UUID)LBItems.DC_CONT_ID.getOrDefault(this.stack, (Object)Util.NIL_UUID));
        buf.writeInt(this.bag.getRows(this.stack));
    }

    public void open() {
        this.bag.checkInit(this.stack);
        this.player.openMenu((MenuProvider)this, this::writeBuffer);
    }
}

