/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.backpack;

import dev.xkmc.l2backpack.content.backpack.BackpackMenuPvd;
import dev.xkmc.l2backpack.content.capability.PickupConfig;
import dev.xkmc.l2backpack.content.common.BackpackModelItem;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.LBConfig;
import dev.xkmc.l2backpack.init.data.LBLang;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class BackpackItem
extends BaseBagItem
implements BackpackModelItem {
    public static final int MAX_ROW = 8;
    public final DyeColor color;

    public BackpackItem(DyeColor color, Item.Properties props) {
        super(props.stacksTo(1).fireResistant());
        this.color = color;
    }

    @Override
    public int getRows(ItemStack stack) {
        int ans;
        int old = (Integer)LBItems.DC_ROW.getOrDefault(stack, (Object)0);
        if (old != (ans = Mth.clamp((int)old, (int)((Integer)LBConfig.SERVER.initialRows.get()), (int)8))) {
            stack.set(LBItems.DC_ROW, (Object)ans);
        }
        return ans;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)LBLang.IDS.BACKPACK_SLOT.get(this.getRows(stack), 8));
        if (LBItems.DC_LOOT_ID.get(stack) != null) {
            list.add((Component)LBLang.IDS.LOOT.get(new Object[0]).withStyle(ChatFormatting.AQUA));
        } else {
            PickupConfig.addText(stack, list);
        }
        LBLang.addInfo(flag, list, LBLang.Info.QUICK_INV_ACCESS, LBLang.Info.KEYBIND, LBLang.Info.UPGRADE, LBLang.Info.LOAD, LBLang.Info.EXIT, LBLang.Info.PICKUP);
        LBLang.altInsert(flag, list);
    }

    @Override
    public void open(ServerPlayer player, PlayerSlot<?> slot, ItemStack stack) {
        new BackpackMenuPvd(player, slot, this, stack).open();
    }

    @Override
    public ResourceLocation getModelTexture(ItemStack stack) {
        return L2Backpack.loc("textures/block/backpack/" + this.color.getName() + ".png");
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }
}

