/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.compat;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.remote.player.EnderSyncCap;
import dev.xkmc.l2backpack.content.remote.player.EnderTickEvent;
import dev.xkmc.l2backpack.init.data.LBConfig;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2backpack.init.registrate.LBMisc;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;

public class SophisticatedCompat {
    public static final ThreadLocal<Unit> ENDER_LOCK = new ThreadLocal();

    public static void init() {
        PlayerInventoryProvider.get().addPlayerInventoryHandler("ender", l -> PlayerInventoryHandler.SINGLE_IDENTIFIER, (player, id) -> SophisticatedCompat.getEnderSize(player), (player, id, slot) -> SophisticatedCompat.getEnderInv(player, slot), false, false, false, false);
    }

    private static int getEnderSize(Player player) {
        if (player instanceof ServerPlayer) {
            return player.getEnderChestInventory().getContainerSize();
        }
        return ((EnderSyncCap)((PlayerCapabilityHolder)LBMisc.ENDER_SYNC.type()).getOrCreate((IAttachmentHolder)player)).getItems(player).size();
    }

    private static ItemStack getEnderInv(Player player, int index) {
        if (ENDER_LOCK.get() != null) {
            return ItemStack.EMPTY;
        }
        if (player instanceof ServerPlayer) {
            return player.getEnderChestInventory().getItem(index);
        }
        return ((EnderSyncCap)((PlayerCapabilityHolder)LBMisc.ENDER_SYNC.type()).getOrCreate((IAttachmentHolder)player)).getItems(player).get(index);
    }

    @SubscribeEvent
    public static void onEnderTick(EnderTickEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player.isSpectator() || player.isDeadOrDying()) {
            return;
        }
        if (!((Boolean)LBConfig.SERVER.sophisticatedEnderTicking.get()).booleanValue()) {
            return;
        }
        if (!SophisticatedCompat.hasEnder(player)) {
            return;
        }
        BackpackWrapper.fromStack((ItemStack)event.getStack()).getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick((Entity)player, player.level(), player.blockPosition()));
    }

    private static boolean hasEnder(ServerPlayer player) {
        ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (stack.is((Item)LBItems.ENDER_BACKPACK.get())) {
            return true;
        }
        Optional<Pair<ItemStack, PlayerSlot<?>>> pairOpt = CuriosCompat.getSlot((LivingEntity)player, e -> e.is((Item)LBItems.ENDER_BACKPACK.get()));
        return pairOpt.isPresent();
    }
}

