/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.compat;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.entry.ISwapEntry;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapManager;
import dev.xkmc.l2backpack.content.quickswap.type.QuickSwapTypes;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalInvWrapper;
import dev.xkmc.l2backpack.content.remote.dimensional.DimensionalItem;
import dev.xkmc.l2backpack.events.ArrowBagEvents;
import dev.xkmc.l2backpack.init.registrate.LBBlocks;
import dev.xkmc.l2backpack.init.registrate.LBItems;
import dev.xkmc.l2library.util.GenericItemStack;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.events.event.GolemEquipEvent;
import dev.xkmc.modulargolems.events.event.GolemHandleItemEvent;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class GolemCompat {
    public static void register() {
        NeoForge.EVENT_BUS.register(GolemCompat.class);
    }

    private static boolean canEquip(ItemStack stack) {
        if (stack.getItem() instanceof BaseBagItem) {
            return true;
        }
        if (stack.getItem() instanceof DimensionalItem) {
            return LBItems.DC_OWNER_ID.get(stack) != null;
        }
        return false;
    }

    @Nullable
    private static GenericItemStack<DimensionalItem> getBackpack(AbstractGolemEntity<?, ?> golem) {
        ItemStack stack;
        Item item;
        for (EquipmentSlot e2 : List.of(EquipmentSlot.CHEST, EquipmentSlot.OFFHAND)) {
            ItemStack stack2 = golem.getItemBySlot(e2);
            Item item2 = stack2.getItem();
            if (!(item2 instanceof DimensionalItem)) continue;
            DimensionalItem item3 = (DimensionalItem)item2;
            return new GenericItemStack((Item)item3, stack2);
        }
        Optional<Pair<ItemStack, PlayerSlot<?>>> opt = CuriosCompat.getSlot(golem, e -> e.getItem() instanceof DimensionalItem);
        if (opt.isPresent() && (item = (stack = (ItemStack)opt.get().getFirst()).getItem()) instanceof DimensionalItem) {
            DimensionalItem item4 = (DimensionalItem)item;
            return new GenericItemStack((Item)item4, stack);
        }
        return null;
    }

    @SubscribeEvent
    public static void onEquip(GolemEquipEvent event) {
        if (GolemCompat.canEquip(event.getStack())) {
            BaseBagItem bag;
            EquipmentSlot slot;
            Item item = event.getStack().getItem();
            if (item instanceof BaseBagItem && (slot = (bag = (BaseBagItem)item).getEquipmentSlot(event.getStack())) != EquipmentSlot.CHEST) {
                event.setSlot(slot, 1);
                return;
            }
            ItemStack back = event.getEntity().getItemBySlot(EquipmentSlot.CHEST);
            if (back.isEmpty() || GolemCompat.canEquip(back)) {
                event.setSlot(EquipmentSlot.CHEST, 1);
            } else {
                event.setSlot(EquipmentSlot.OFFHAND, 1);
            }
        }
    }

    @SubscribeEvent
    public static void onHandleItem(GolemHandleItemEvent event) {
        if (event.getItem().isRemoved()) {
            return;
        }
        ItemStack stack = event.getItem().getItem();
        if (stack.isEmpty()) {
            return;
        }
        GenericItemStack<DimensionalItem> backpack = GolemCompat.getBackpack(event.getEntity());
        if (backpack == null) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getEntity().level();
        Optional<StorageContainer> cont = ((DimensionalItem)backpack.item()).getContainer(backpack.stack(), level);
        if (cont.isEmpty()) {
            return;
        }
        StorageContainer storage = cont.get();
        DimensionalInvWrapper handler = new DimensionalInvWrapper((Container)storage.get(), storage.id);
        ItemStack remain = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        event.getItem().setItem(remain);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onArrowFind(ArrowBagEvents.ArrowFindEvent event) {
        GenericItemStack<DimensionalItem> backpack;
        Level stack;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof AbstractGolemEntity)) {
            return;
        }
        AbstractGolemEntity golem = (AbstractGolemEntity)livingEntity;
        IQuickSwapToken<?> token = QuickSwapManager.getToken(event.getEntity(), event.getStack(), false);
        if (token != null && token.type() == QuickSwapTypes.ARROW) {
            List<?> arrows = token.getList();
            for (int i = 0; i < 9; ++i) {
                stack = ((ISwapEntry)arrows.get(i)).getStack();
                if (!event.setProjectile((Pair<ItemStack, IntConsumer>)Pair.of((Object)stack, token::shrink))) continue;
                return;
            }
        }
        if ((backpack = GolemCompat.getBackpack(golem)) == null) {
            return;
        }
        stack = event.getEntity().level();
        if (stack instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)stack;
            Optional<StorageContainer> cont = ((DimensionalItem)backpack.item()).getContainer(backpack.stack(), level);
            if (cont.isEmpty()) {
                return;
            }
            StorageContainer storage = cont.get();
            for (int i = 0; i < storage.get().getContainerSize(); ++i) {
                ItemStack stack2 = storage.get().getItem(i);
                if (!event.setProjectile((Pair<ItemStack, IntConsumer>)Pair.of((Object)stack2, x -> storage.get().setChanged()))) continue;
                return;
            }
        }
    }

    public static void genBlockTag(RegistrateTagsProvider.IntrinsicImpl<Block> pvd) {
        pvd.addTag(MGTagGen.POTENTIAL_DST).add((Object)((Block)LBBlocks.DIMENSIONAL.get()));
    }
}

