/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.compat;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2menustacker.screen.source.ItemSource;
import dev.xkmc.l2menustacker.screen.source.PlayerSlot;
import dev.xkmc.l2tabs.compat.api.AccessoriesMultiplex;
import dev.xkmc.l2tabs.compat.track.CurioSlotData;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosCompat {
    public static Optional<Pair<ItemStack, PlayerSlot<?>>> getSlot(LivingEntity player, Predicate<ItemStack> pred) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getSlotImpl(player, pred);
        }
        return Optional.empty();
    }

    public static ItemStack getItem(LivingEntity player, Item item) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getItemImpl(player, item);
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack getItemImpl(LivingEntity player, Item item) {
        Optional curio = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curio.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Optional ans = ((ICuriosItemHandler)curio.get()).findFirstCurio(item);
        return ans.map(SlotResult::stack).orElse(ItemStack.EMPTY);
    }

    public static Optional<ItemStack> getRenderingSlot(LivingEntity player, Predicate<ItemStack> pred) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getRenderingSlotImpl(player, pred);
        }
        return Optional.empty();
    }

    private static Optional<Pair<ItemStack, PlayerSlot<?>>> getSlotImpl(LivingEntity player, Predicate<ItemStack> pred) {
        Optional ans;
        Optional curio = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curio.isPresent() && (ans = ((ICuriosItemHandler)curio.get()).findFirstCurio(pred)).isPresent()) {
            return Optional.of(Pair.of((Object)((SlotResult)ans.get()).stack(), (Object)new PlayerSlot((ItemSource)AccessoriesMultiplex.IS_CURIOS.get(), (Record)new CurioSlotData(((SlotResult)ans.get()).slotContext().identifier(), ((SlotResult)ans.get()).slotContext().index()))));
        }
        return Optional.empty();
    }

    private static Optional<ItemStack> getRenderingSlotImpl(LivingEntity player, Predicate<ItemStack> pred) {
        Optional curio = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curio.isPresent()) {
            Map e = ((ICuriosItemHandler)curio.get()).getCurios();
            for (ICurioStacksHandler ent : e.values()) {
                ItemStack stack;
                int i;
                if (!ent.isVisible()) continue;
                for (i = 0; i < ent.getCosmeticStacks().getSlots(); ++i) {
                    stack = ent.getCosmeticStacks().getStackInSlot(i);
                    if (!pred.test(stack)) continue;
                    return Optional.of(stack);
                }
                for (i = 0; i < ent.getStacks().getSlots(); ++i) {
                    if (ent.getRenders().size() > i && !((Boolean)ent.getRenders().get(i)).booleanValue() || !pred.test(stack = ent.getStacks().getStackInSlot(i))) continue;
                    return Optional.of(stack);
                }
            }
        }
        return Optional.empty();
    }
}

